/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.DirectQuickSelectSketchR;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.Rebuilder;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdateReturnState;
import org.apache.datasketches.thetacommon.HashOperations;

class DirectQuickSelectSketch
extends DirectQuickSelectSketchR {
    private static final double DQS_RESIZE_THRESHOLD = 0.9375;
    int hashTableThreshold_;
    private final MemorySegmentRequest mSegReq;

    private DirectQuickSelectSketch(MemorySegment wseg, MemorySegmentRequest mSegReq, long seed) {
        this.mSegReq = mSegReq == null ? MemorySegmentRequest.DEFAULT : mSegReq;
        super(wseg, seed);
    }

    DirectQuickSelectSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, MemorySegment dstSeg, MemorySegmentRequest mSegReq, boolean unionGadget) {
        Family family = unionGadget ? Family.UNION : Family.QUICKSELECT;
        int preambleLongs = unionGadget ? Family.UNION.getMinPreLongs() : Family.QUICKSELECT.getMinPreLongs();
        int lgRF = rf.lg();
        int lgArrLongs = lgRF == 0 ? lgNomLongs + 1 : 5;
        int minReqBytes = PreambleUtil.getUpdatableSegBytes(lgArrLongs, preambleLongs);
        long curSegCapBytes = dstSeg.byteSize();
        if (curSegCapBytes < (long)minReqBytes) {
            throw new SketchesArgumentException("MemorySegment capacity is less than minimum required: " + curSegCapBytes + " < " + minReqBytes);
        }
        PreambleUtil.insertPreLongs(dstSeg, preambleLongs);
        PreambleUtil.insertLgResizeFactor(dstSeg, lgRF);
        PreambleUtil.insertSerVer(dstSeg, 3);
        PreambleUtil.insertFamilyID(dstSeg, family.getID());
        PreambleUtil.insertLgNomLongs(dstSeg, lgNomLongs);
        PreambleUtil.insertLgArrLongs(dstSeg, lgArrLongs);
        PreambleUtil.insertFlags(dstSeg, 4);
        PreambleUtil.insertSeedHash(dstSeg, Util.computeSeedHash(seed));
        PreambleUtil.insertCurCount(dstSeg, 0);
        PreambleUtil.insertP(dstSeg, p);
        long thetaLong = (long)((double)p * 9.223372036854776E18);
        PreambleUtil.insertThetaLong(dstSeg, thetaLong);
        if (unionGadget) {
            PreambleUtil.insertUnionThetaLong(dstSeg, thetaLong);
        }
        dstSeg.asSlice((long)(preambleLongs << 3), 8 << lgArrLongs).fill((byte)0);
        this.hashTableThreshold_ = DirectQuickSelectSketch.getOffHeapHashTableThreshold(lgNomLongs, lgArrLongs);
        this.mSegReq = mSegReq == null ? MemorySegmentRequest.DEFAULT : mSegReq;
        super(dstSeg, seed);
    }

    static DirectQuickSelectSketch writableWrap(MemorySegment srcSeg, MemorySegmentRequest mSegReq, long seed) {
        int preambleLongs = ThetaSketch.getPreambleLongs(srcSeg);
        int lgNomLongs = PreambleUtil.extractLgNomLongs(srcSeg);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(srcSeg);
        UpdatableThetaSketch.checkUnionAndQuickSelectFamily(srcSeg, preambleLongs, lgNomLongs);
        DirectQuickSelectSketch.checkSegIntegrity(srcSeg, seed, preambleLongs, lgNomLongs, lgArrLongs);
        if (DirectQuickSelectSketch.isResizeFactorIncorrect(srcSeg, lgNomLongs, lgArrLongs)) {
            PreambleUtil.insertLgResizeFactor(srcSeg, ResizeFactor.X2.lg());
        }
        DirectQuickSelectSketch dqss = new DirectQuickSelectSketch(srcSeg, mSegReq, seed);
        dqss.hashTableThreshold_ = DirectQuickSelectSketch.getOffHeapHashTableThreshold(lgNomLongs, lgArrLongs);
        return dqss;
    }

    static DirectQuickSelectSketch fastWritableWrap(MemorySegment srcSeg, MemorySegmentRequest mSegReq, long seed) {
        int lgNomLongs = PreambleUtil.extractLgNomLongs(srcSeg);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(srcSeg);
        DirectQuickSelectSketch dqss = new DirectQuickSelectSketch(srcSeg, mSegReq, seed);
        dqss.hashTableThreshold_ = DirectQuickSelectSketch.getOffHeapHashTableThreshold(lgNomLongs, lgArrLongs);
        return dqss;
    }

    @Override
    public UpdatableThetaSketch rebuild() {
        int lgNomLongs = this.getLgNomLongs();
        int preambleLongs = this.wseg_.get(ValueLayout.JAVA_BYTE, 0L) & 0x3F;
        if (this.getRetainedEntries(true) > 1 << lgNomLongs) {
            Rebuilder.quickSelectAndRebuild(this.wseg_, preambleLongs, lgNomLongs);
        }
        return this;
    }

    @Override
    public void reset() {
        int arrLongs = 1 << this.getLgArrLongs();
        int preambleLongs = this.wseg_.get(ValueLayout.JAVA_BYTE, 0L) & 0x3F;
        int preBytes = preambleLongs << 3;
        this.wseg_.asSlice((long)preBytes, (long)arrLongs * 8L).fill((byte)0);
        this.wseg_.set(ValueLayout.JAVA_BYTE, 5L, (byte)4);
        this.wseg_.set(ValueLayout.JAVA_INT_UNALIGNED, 8L, 0);
        float p = this.wseg_.get(ValueLayout.JAVA_FLOAT_UNALIGNED, 12L);
        long thetaLong = (long)((double)p * 9.223372036854776E18);
        this.wseg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L, thetaLong);
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        int preambleLongs;
        HashOperations.checkHashCorruption(hash);
        this.wseg_.set(ValueLayout.JAVA_BYTE, 5L, (byte)(this.wseg_.get(ValueLayout.JAVA_BYTE, 5L) & 0xFFFFFFFB));
        long thetaLong = this.getThetaLong();
        int lgNomLongs = this.getLgNomLongs();
        if (HashOperations.continueCondition(thetaLong, hash)) {
            return UpdateReturnState.RejectedOverTheta;
        }
        int lgArrLongs = this.getLgArrLongs();
        int index = HashOperations.hashSearchOrInsertMemorySegment(this.wseg_, lgArrLongs, hash, (preambleLongs = this.wseg_.get(ValueLayout.JAVA_BYTE, 0L) & 0x3F) << 3);
        if (index >= 0) {
            return UpdateReturnState.RejectedDuplicate;
        }
        int curCount = this.getRetainedEntries(true) + 1;
        this.wseg_.set(ValueLayout.JAVA_INT_UNALIGNED, 8L, curCount);
        if (this.isOutOfSpace(curCount)) {
            if (lgArrLongs > lgNomLongs) {
                assert (lgArrLongs == lgNomLongs + 1) : "lgArr: " + lgArrLongs + ", lgNom: " + lgNomLongs;
                Rebuilder.quickSelectAndRebuild(this.wseg_, preambleLongs, lgNomLongs);
                return UpdateReturnState.InsertedCountIncrementedRebuilt;
            }
            int lgRF = this.getLgRF();
            int actLgRF = Rebuilder.actLgResizeFactor(this.wseg_.byteSize(), lgArrLongs, preambleLongs, lgRF);
            int tgtLgArrLongs = Math.min(lgArrLongs + actLgRF, lgNomLongs + 1);
            if (actLgRF > 0) {
                Rebuilder.resize(this.wseg_, preambleLongs, lgArrLongs, tgtLgArrLongs);
                this.hashTableThreshold_ = DirectQuickSelectSketch.getOffHeapHashTableThreshold(lgNomLongs, tgtLgArrLongs);
                return UpdateReturnState.InsertedCountIncrementedResized;
            }
            int preBytes = preambleLongs << 3;
            tgtLgArrLongs = Math.min(lgArrLongs + lgRF, lgNomLongs + 1);
            int tgtArrBytes = 8 << tgtLgArrLongs;
            int reqBytes = tgtArrBytes + preBytes;
            MemorySegment newDstSeg = this.mSegReq.request(reqBytes);
            Rebuilder.moveAndResize(this.wseg_, preambleLongs, lgArrLongs, newDstSeg, tgtLgArrLongs, thetaLong);
            MemorySegment oldSeg = this.wseg_;
            this.wseg_ = newDstSeg;
            this.mSegReq.requestClose(oldSeg);
            this.hashTableThreshold_ = DirectQuickSelectSketch.getOffHeapHashTableThreshold(lgNomLongs, tgtLgArrLongs);
            return UpdateReturnState.InsertedCountIncrementedResized;
        }
        return UpdateReturnState.InsertedCountIncremented;
    }

    @Override
    boolean isOutOfSpace(int numEntries) {
        return numEntries > this.hashTableThreshold_;
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_BRANCHES"}, justification="False Positive, see the code comments")
    protected static final int getOffHeapHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.9375 : 0.9375;
        return (int)(fraction * (double)(1 << lgArrLongs));
    }
}

