/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.extended;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.util.Strings;

public final class NoticeOfDisconnect
extends ExtendedResponseImpl {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20036";
    public static final NoticeOfDisconnect UNAVAILABLE = new NoticeOfDisconnect(ResultCodeEnum.UNAVAILABLE);
    public static final NoticeOfDisconnect PROTOCOLERROR = new NoticeOfDisconnect(ResultCodeEnum.PROTOCOL_ERROR);
    public static final NoticeOfDisconnect STRONGAUTHREQUIRED = new NoticeOfDisconnect(ResultCodeEnum.STRONG_AUTH_REQUIRED);

    private NoticeOfDisconnect(ResultCodeEnum rcode) {
        super(0, EXTENSION_OID);
        switch (rcode) {
            case UNAVAILABLE: {
                break;
            }
            case PROTOCOL_ERROR: {
                break;
            }
            case STRONG_AUTH_REQUIRED: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04166, (Object[])new Object[]{ResultCodeEnum.UNAVAILABLE, ResultCodeEnum.PROTOCOL_ERROR, ResultCodeEnum.STRONG_AUTH_REQUIRED}));
            }
        }
        super.getLdapResult().setDiagnosticMessage(rcode.toString() + ": The server will disconnect!");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public byte[] getResponse() {
        return Strings.EMPTY_BYTES;
    }

    public void setResponse(byte[] value) {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04173, (Object[])new Object[0]));
    }

    @Override
    public String getResponseName() {
        return EXTENSION_OID;
    }

    @Override
    public void setResponseName(String oid) {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04168, (Object[])new Object[]{EXTENSION_OID}));
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + this.getClass().getName().hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof NoticeOfDisconnect;
    }
}

