/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.extended;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.message.AbstractExtendedResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.util.Strings;

public final class ExtendedNoDResponse
extends AbstractExtendedResponse {
    static final long serialVersionUID = 2L;
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20036";
    public static final ExtendedNoDResponse UNAVAILABLE = new ExtendedNoDResponse(ResultCodeEnum.UNAVAILABLE);
    public static final ExtendedNoDResponse PROTOCOLERROR = new ExtendedNoDResponse(ResultCodeEnum.PROTOCOL_ERROR);
    public static final ExtendedNoDResponse STRONGAUTHREQUIRED = new ExtendedNoDResponse(ResultCodeEnum.STRONG_AUTH_REQUIRED);

    private ExtendedNoDResponse(ResultCodeEnum rcode) {
        super(EXTENSION_OID);
        switch (rcode) {
            case UNAVAILABLE: {
                break;
            }
            case PROTOCOL_ERROR: {
                break;
            }
            case STRONG_AUTH_REQUIRED: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13503_RESULT_CODE_SHOULD_BE_IN, new Object[]{ResultCodeEnum.UNAVAILABLE, ResultCodeEnum.PROTOCOL_ERROR, ResultCodeEnum.STRONG_AUTH_REQUIRED}));
            }
        }
        super.getLdapResult().setDiagnosticMessage(rcode.toString() + ": The server will disconnect!");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public byte[] getResponse() {
        return Strings.EMPTY_BYTES;
    }
}

