/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.storedProcedure;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureParameter;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureRequest;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureResponse;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureResponseImpl;
import org.apache.directory.api.ldap.model.message.OpaqueExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;

public class StoredProcedureRequestImpl
extends OpaqueExtendedRequest
implements StoredProcedureRequest {
    private String language = "Java";
    private byte[] procedure = Strings.EMPTY_BYTES;
    private List<StoredProcedureParameter> parameters = new ArrayList<StoredProcedureParameter>();

    public StoredProcedureRequestImpl(int messageId) {
        super(messageId);
        this.setRequestName("1.3.6.1.4.1.18060.0.1.6");
    }

    public StoredProcedureRequestImpl() {
        this.setRequestName("1.3.6.1.4.1.18060.0.1.6");
    }

    public StoredProcedureRequestImpl(int messageId, String procedure, String language) {
        super(messageId);
        this.setRequestName("1.3.6.1.4.1.18060.0.1.6");
        this.language = language;
        this.procedure = Strings.getBytesUtf8(procedure);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public byte[] getProcedure() {
        if (this.procedure == null) {
            return null;
        }
        byte[] copy = new byte[this.procedure.length];
        System.arraycopy(this.procedure, 0, copy, 0, this.procedure.length);
        return copy;
    }

    @Override
    public void setProcedure(byte[] procedure) {
        if (procedure != null) {
            this.procedure = new byte[procedure.length];
            System.arraycopy(procedure, 0, this.procedure, 0, procedure.length);
        } else {
            this.procedure = null;
        }
    }

    @Override
    public List<StoredProcedureParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void addParameter(StoredProcedureParameter parameter) {
        this.parameters.add(parameter);
    }

    public void setProcedure(String procedure) {
        this.procedure = Strings.getBytesUtf8(procedure);
    }

    @Override
    public String getProcedureSpecification() {
        return Strings.utf8ToString(this.procedure);
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public Object getParameterType(int index) {
        if (!"java".equals(this.language)) {
            return this.parameters.get(index).getType();
        }
        return this.getJavaParameterType(index);
    }

    public Object getParameterTypeString(int index) {
        byte[] obj;
        if (!"java".equals(this.language) && (obj = this.parameters.get(index).getType()) instanceof byte[]) {
            return Strings.utf8ToString(obj);
        }
        return this.getJavaParameterType(index);
    }

    @Override
    public Class<?> getJavaParameterType(int index) {
        throw new NotImplementedException(I18n.err(I18n.ERR_9104_CLASS_LOADING_OF_PROC_TYPE_NOT_IMPLEMENTED, new Object[0]));
    }

    @Override
    public Object getParameterValue(int index) {
        if (!"java".equals(this.language)) {
            return this.parameters.get(index).getValue();
        }
        return this.getJavaParameterValue(index);
    }

    public Object getParameterValueString(int index) {
        byte[] obj;
        if (!"java".equals(this.language) && (obj = this.parameters.get(index).getValue()) instanceof byte[]) {
            String str = Strings.utf8ToString(obj);
            String type = (String)this.getParameterTypeString(index);
            if ("int".equals(type)) {
                try {
                    return IntegerDecoder.parse(new BerValue(obj));
                }
                catch (IntegerDecoderException e) {
                    throw new RuntimeException(I18n.err(I18n.ERR_9200_INTERGER_DECODING_FAILURE, Strings.dumpBytes(obj)), e);
                }
            }
            return str;
        }
        return this.getJavaParameterValue(index);
    }

    @Override
    public Object getJavaParameterValue(int index) {
        throw new NotImplementedException(I18n.err(I18n.ERR_9105_CONVERSION_VALUE_TO_JAVA_NOT_IMPLEMENTED, new Object[0]));
    }

    @Override
    public void addParameter(Object type, Object value) {
        StoredProcedureParameter parameter = new StoredProcedureParameter();
        parameter.setType((byte[])type);
        parameter.setValue((byte[])value);
        this.parameters.add(parameter);
    }

    @Override
    public StoredProcedureResponse getResultResponse() {
        if (this.getResponse() == null) {
            this.setResponse(new StoredProcedureResponseImpl(this.getMessageId()));
        }
        return (StoredProcedureResponse)this.getResponse();
    }
}

