/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.cometd.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.osgi.framework.BundleContext;

public final class CometdConfig {
    private static final String COMETD_PATH = "org.apache.felix.http.cometd.path";
    private static final String DEFAULT_COMETD_PATH = "/system/cometd";
    private final BundleContext context;
    private String path;

    public CometdConfig(BundleContext context) {
        this.context = context;
        this.reset();
    }

    public String getPath() {
        return this.path;
    }

    public void reset() {
        this.update(null);
    }

    public void update(Dictionary props) {
        if (props == null) {
            props = new Properties();
        }
        this.path = this.getProperty(props, COMETD_PATH, DEFAULT_COMETD_PATH);
    }

    private String getProperty(Dictionary props, String name, String defValue) {
        Object value = props.get(name);
        if (value == null) {
            value = this.context.getProperty(name);
        }
        return value != null ? String.valueOf(value) : defValue;
    }
}

