/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import org.objectweb.asm.ClassWriter;

public class ClassLoaderAwareClassWriter
extends ClassWriter {
    private static final String OBJECT_INTERNAL_NAME = "java/lang/Object";
    private final String className;
    private final String superClass;
    private final ClassLoader classLoader;

    public ClassLoaderAwareClassWriter(int flags, String className, String superClass, ClassLoader loader) {
        super(flags);
        this.className = className;
        this.superClass = superClass;
        this.classLoader = loader;
    }

    @Override
    protected final String getCommonSuperClass(String type1, String type2) {
        Class<?> d;
        Class<?> c;
        if (type1.equals(type2)) {
            return type1;
        }
        if (type1.equals(OBJECT_INTERNAL_NAME) || type2.equals(OBJECT_INTERNAL_NAME)) {
            return OBJECT_INTERNAL_NAME;
        }
        if (type1.equals(this.className.replace(".", "/")) && this.superClass != null) {
            return this.getCommonSuperClass(this.superClass.replace(".", "/"), type2);
        }
        if (type2.equals(this.className.replace(".", "/")) && this.superClass != null) {
            return this.getCommonSuperClass(type1, this.superClass.replace(".", "/"));
        }
        try {
            c = this.classLoader.loadClass(type1.replace('/', '.'));
            d = this.classLoader.loadClass(type2.replace('/', '.'));
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        if (c.isAssignableFrom(d)) {
            return type1;
        }
        if (d.isAssignableFrom(c)) {
            return type2;
        }
        if (c.isInterface() || d.isInterface()) {
            return OBJECT_INTERNAL_NAME;
        }
        while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
        }
        return c.getName().replace('.', '/');
    }
}

