/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

class ReentrantLock {
    protected Thread m_owner = null;
    protected long m_holds = 0L;

    ReentrantLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (caller == this.m_owner) {
                ++this.m_holds;
            } else {
                try {
                    while (this.m_owner != null) {
                        this.wait();
                    }
                    this.m_owner = caller;
                    this.m_holds = 1L;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (caller == this.m_owner) {
                ++this.m_holds;
                return true;
            }
            if (this.m_owner == null) {
                this.m_owner = caller;
                this.m_holds = 1L;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            try {
                do {
                    this.wait(waitTime);
                    if (caller == this.m_owner) {
                        ++this.m_holds;
                        return true;
                    }
                    if (this.m_owner != null) continue;
                    this.m_owner = caller;
                    this.m_holds = 1L;
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        if (Thread.currentThread() != this.m_owner) {
            throw new Error("Illegal Lock usage");
        }
        if (--this.m_holds == 0L) {
            this.m_owner = null;
            this.notify();
        }
    }

    public synchronized void release(long n) {
        if (Thread.currentThread() != this.m_owner || n > this.m_holds) {
            throw new Error("Illegal Lock usage");
        }
        this.m_holds -= n;
        if (this.m_holds == 0L) {
            this.m_owner = null;
            this.notify();
        }
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.m_owner) {
            return 0L;
        }
        return this.m_holds;
    }
}

