/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.obr.internal;

import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OsgiDeployer
implements Runnable {
    private final Resolver obrResolver;
    private static final Logger logger = LoggerFactory.getLogger(OsgiDeployer.class);
    private final boolean startBundles;

    OsgiDeployer(Resolver obrResolver, boolean startBundles) {
        this.obrResolver = obrResolver;
        this.startBundles = startBundles;
    }

    static void deploy(Resolver obrResolver, boolean startBundles) {
        OsgiDeployer d = new OsgiDeployer(obrResolver, startBundles);
        Thread t = new Thread((Runnable)d, "OBR Bundle Deployer (OSGi API)");
        t.start();
    }

    @Override
    public void run() {
        try {
            if (this.obrResolver.resolve()) {
                OsgiDeployer.logResource("Installing Requested Resources", this.obrResolver.getAddedResources());
                OsgiDeployer.logResource("Installing Required Resources", this.obrResolver.getRequiredResources());
                OsgiDeployer.logResource("Installing Optional Resources", this.obrResolver.getOptionalResources());
                this.obrResolver.deploy(this.startBundles);
            } else {
                OsgiDeployer.logRequirements("Cannot Install requested bundles due to unsatisfied requirements", this.obrResolver.getUnsatisfiedRequirements());
            }
        }
        catch (Exception ie) {
            logger.error("Cannot install bundles", (Throwable)ie);
        }
    }

    public static void logResource(String message, Resource[] res) {
        if (res != null && res.length > 0) {
            logger.info(message);
            for (int i = 0; i < res.length; ++i) {
                logger.info("  " + i + ": " + res[i].getSymbolicName() + ", " + res[i].getVersion());
            }
        }
    }

    public static void logRequirements(String message, Requirement[] reasons) {
        logger.error(message);
        for (int i = 0; reasons != null && i < reasons.length; ++i) {
            String moreInfo = reasons[i].getComment();
            if (moreInfo == null) {
                moreInfo = reasons[i].getFilter().toString();
            }
            logger.error("  " + i + ": " + reasons[i].getName() + " (" + moreInfo + ")");
        }
    }
}

