/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.raft.jraft.storage.logit;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;

/**
 * Moved from rocketmq.
 *
 *  https://raw.githubusercontent.com/apache/rocketmq/master/store/src/main/java/org/apache/rocketmq/store/util/LibC.java
 */
public interface LibC extends Library {
    LibC INSTANCE      = Native.load(Platform.isWindows() ? "msvcrt" : "c", LibC.class);

    int  MADV_WILLNEED = 3;
    int  MADV_DONTNEED = 4;

    int  MCL_CURRENT   = 1;
    int  MCL_FUTURE    = 2;
    int  MCL_ONFAULT   = 4;

    /* sync memory asynchronously */
    int  MS_ASYNC      = 0x0001;
    /* invalidate mappings & caches */
    int  MS_INVALIDATE = 0x0002;
    /* synchronous memory sync */
    int  MS_SYNC       = 0x0004;

    int mlock(Pointer var1, NativeLong var2);

    int munlock(Pointer var1, NativeLong var2);

    int madvise(Pointer var1, NativeLong var2, int var3);

    Pointer memset(Pointer p, int v, long len);

    int mlockall(int flags);

    int msync(Pointer p, NativeLong length, int flags);
}
