/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.events.StoppingIndexEventParameters;
import org.apache.ignite3.internal.catalog.storage.AbstractChangeIndexStatusEntry;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.tostring.S;

public class DropIndexEntry
extends AbstractChangeIndexStatusEntry
implements Fireable {
    public DropIndexEntry(int indexId) {
        super(indexId, CatalogIndexStatus.STOPPING);
    }

    public int indexId() {
        return this.indexId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_INDEX.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.INDEX_STOPPING;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new StoppingIndexEventParameters(causalityToken, catalogVersion, this.indexId);
    }

    @Override
    public String toString() {
        return S.toString(DropIndexEntry.class, this, super.toString());
    }
}

