/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.sql.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.sql.table.TableRow;

public class Table<T> {
    private final String[] header;
    private final List<TableRow<T>> content;

    public Table(List<String> ids, List<T> content) {
        if (!content.isEmpty() && !ids.isEmpty() && content.size() % ids.size() != 0) {
            throw new IllegalArgumentException("Content size should be divisible by columns count");
        }
        this.header = Table.parseHeader(ids);
        this.content = new ArrayList<TableRow<T>>();
        int columnsCount = ids.size();
        int n = columnsCount != 0 ? content.size() / columnsCount : 0;
        for (int i = 0; i < n; ++i) {
            List<T> elements = content.subList(i * columnsCount, (i + 1) * columnsCount);
            this.content.add(new TableRow<T>(elements));
        }
    }

    private static String[] parseHeader(List<String> header) {
        if (!header.isEmpty()) {
            return header.toArray(new String[0]);
        }
        return new String[]{"EMPTY"};
    }

    public String[] header() {
        return this.header;
    }

    public Object[][] content() {
        List collect = this.content.stream().map(row -> new ArrayList(row.getValues())).map(strings -> strings.toArray(new Object[0])).collect(Collectors.toList());
        return (Object[][])collect.toArray((T[])new Object[0][0]);
    }

    public static Table<String> fromResultSet(ResultSet resultSet) {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 1; i <= columnCount; ++i) {
                ids.add(metaData.getColumnLabel(i));
            }
            ArrayList<String> content = new ArrayList<String>();
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    content.add(resultSet.getString(i));
                }
            }
            return new Table<String>(ids, content);
        }
        catch (SQLException e) {
            return null;
        }
    }
}

