/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import org.apache.ignite3.internal.metastorage.command.PutCommand;
import org.apache.ignite3.internal.metastorage.command.PutCommandImpl;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class PutCommandSerializer
implements MessageSerializer<PutCommand> {
    public static final PutCommandSerializer INSTANCE = new PutCommandSerializer();

    private PutCommandSerializer() {
    }

    @Override
    public boolean writeMessage(PutCommand msg, MessageWriter writer) throws MessageMappingException {
        PutCommandImpl message = (PutCommandImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeHybridTimestamp("initiatorTime", message.initiatorTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeByteBuffer("key", message.key());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeHybridTimestamp("safeTime", message.safeTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeByteBuffer("value", message.value());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

