/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.impl;

import org.apache.ignite3.internal.raft.storage.LogStorageFactory;
import org.apache.ignite3.internal.raft.storage.RaftMetaStorageFactory;
import org.apache.ignite3.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite3.raft.jraft.core.DefaultJRaftServiceFactory;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.LogStorage;
import org.apache.ignite3.raft.jraft.storage.RaftMetaStorage;
import org.apache.ignite3.raft.jraft.storage.SnapshotStorage;
import org.apache.ignite3.raft.jraft.storage.impl.LocalRaftMetaStorage;
import org.apache.ignite3.raft.jraft.storage.snapshot.local.LocalSnapshotStorage;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.StringUtils;
import org.jetbrains.annotations.TestOnly;

public class IgniteJraftServiceFactory
extends DefaultJRaftServiceFactory {
    private final LogStorageFactory logStorageFactory;
    private volatile SnapshotStorageFactory snapshotStorageFactory = LocalSnapshotStorage::new;
    private volatile RaftMetaStorageFactory raftMetaStorageFactory = LocalRaftMetaStorage::new;

    public IgniteJraftServiceFactory(LogStorageFactory factory) {
        this.logStorageFactory = factory;
    }

    public IgniteJraftServiceFactory setSnapshotStorageFactory(SnapshotStorageFactory snapshotStorageFactory) {
        this.snapshotStorageFactory = snapshotStorageFactory;
        return this;
    }

    public IgniteJraftServiceFactory setRaftMetaStorageFactory(RaftMetaStorageFactory raftMetaStorageFactory) {
        this.raftMetaStorageFactory = raftMetaStorageFactory;
        return this;
    }

    @Override
    public LogStorage createLogStorage(String groupId, RaftOptions raftOptions) {
        Requires.requireTrue(StringUtils.isNotBlank(groupId), "Blank group id.");
        return this.logStorageFactory.createLogStorage(groupId, raftOptions);
    }

    @Override
    public SnapshotStorage createSnapshotStorage(String uri, RaftOptions raftOptions) {
        Requires.requireTrue(!StringUtils.isBlank(uri), "Blank snapshot storage uri.");
        return this.snapshotStorageFactory.createSnapshotStorage(uri, raftOptions);
    }

    @Override
    public RaftMetaStorage createRaftMetaStorage(String uri, RaftOptions raftOptions) {
        Requires.requireTrue(!StringUtils.isBlank(uri), "Blank raft meta storage uri.");
        return this.raftMetaStorageFactory.createRaftMetaStorage(uri, raftOptions);
    }

    @TestOnly
    public LogStorageFactory logStorageFactory() {
        return this.logStorageFactory;
    }
}

