/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.raft.storage.impl.RocksDbSharedLogStorage;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.entity.LogId;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.option.LogManagerOptions;
import org.apache.ignite3.raft.jraft.storage.LogManager;
import org.apache.ignite3.raft.jraft.storage.LogStorage;
import org.apache.ignite3.raft.jraft.storage.impl.LogManagerImpl;

public class StripeAwareLogManager
extends LogManagerImpl {
    private static final IgniteLogger LOG = Loggers.forClass(StripeAwareLogManager.class);
    private LogStorage logStorage;
    private Stripe stripe;
    private int maxAppendBufferSize;
    private boolean sharedLogStorage;

    @Override
    public boolean init(LogManagerOptions opts) {
        LogStorage logStorage = opts.getLogStorage();
        this.sharedLogStorage = logStorage instanceof RocksDbSharedLogStorage;
        this.logStorage = logStorage;
        this.maxAppendBufferSize = opts.getRaftOptions().getMaxAppendBufferSize();
        boolean isInitSuccessfully = super.init(opts);
        int stripe = opts.getLogManagerDisruptor().getStripe(opts.getNode().getNodeId());
        assert (stripe != -1);
        this.stripe = opts.getLogStripes().get(stripe);
        return isInitSuccessfully;
    }

    @Override
    protected int appendToLogStorage(List<LogEntry> toAppend) {
        if (this.sharedLogStorage) {
            return ((RocksDbSharedLogStorage)this.logStorage).appendEntriesToBatch(toAppend) ? toAppend.size() : 0;
        }
        return this.logStorage.appendEntries(toAppend);
    }

    @Override
    protected LogManagerImpl.AppendBatcher newAppendBatcher(List<LogManager.StableClosure> storages, int cap, LogId diskId) {
        return new StripeAwareAppendBatcher(storages, cap, diskId);
    }

    public static class Stripe {
        private int bufferSize;
        private int size;
        private final Set<StripeAwareAppendBatcher> appendBatchers = new HashSet<StripeAwareAppendBatcher>();

        void addBatcher(StripeAwareAppendBatcher appendBatcher, int bufferSize) {
            this.appendBatchers.add(appendBatcher);
            ++this.size;
            this.bufferSize += bufferSize;
        }

        void flush() {
            if (this.size == 0) {
                return;
            }
            for (StripeAwareAppendBatcher stripeAwareAppendBatcher : this.appendBatchers) {
                stripeAwareAppendBatcher.appendToStorage();
            }
            try {
                for (StripeAwareAppendBatcher stripeAwareAppendBatcher : this.appendBatchers) {
                    stripeAwareAppendBatcher.commitWriteBatch();
                }
            }
            catch (Exception e) {
                LOG.error("**Critical error**, failed to appendEntries.", (Throwable)e);
                for (StripeAwareAppendBatcher appendBatcher : this.appendBatchers) {
                    appendBatcher.reportError(RaftError.EIO.getNumber(), "Fail to append log entries", new Object[0]);
                }
                return;
            }
            for (StripeAwareAppendBatcher stripeAwareAppendBatcher : this.appendBatchers) {
                stripeAwareAppendBatcher.notifyClosures();
            }
            this.appendBatchers.clear();
            this.size = 0;
            this.bufferSize = 0;
        }
    }

    private class StripeAwareAppendBatcher
    extends LogManagerImpl.AppendBatcher {
        private LogId lastIdCandidate;

        StripeAwareAppendBatcher(List<LogManager.StableClosure> storage, int cap, LogId lastId) {
            super(storage, cap, new ArrayList<LogEntry>(), lastId);
        }

        @Override
        protected LogId flush() {
            StripeAwareLogManager.this.stripe.flush();
            return this.lastId;
        }

        void appendToStorage() {
            assert (this.size > 0);
            this.lastIdCandidate = StripeAwareLogManager.super.appendToStorage(this.toAppend);
        }

        void commitWriteBatch() {
            if (StripeAwareLogManager.this.sharedLogStorage) {
                ((RocksDbSharedLogStorage)StripeAwareLogManager.this.logStorage).commitWriteBatch();
            }
        }

        void reportError(int code, String fmt, Object ... args) {
            StripeAwareLogManager.super.reportError(code, fmt, args);
        }

        void notifyClosures() {
            this.lastId = this.lastIdCandidate;
            for (int i = 0; i < this.size; ++i) {
                ((LogManager.StableClosure)this.storage.get(i)).getEntries().clear();
                Status st = null;
                try {
                    st = StripeAwareLogManager.this.hasError ? new Status(RaftError.EIO, "Corrupted LogStorage", new Object[0]) : Status.OK();
                    ((LogManager.StableClosure)this.storage.get(i)).run(st);
                    continue;
                }
                catch (Throwable t) {
                    LOG.error("Fail to run closure with status: {}.", t, st);
                }
            }
            this.toAppend.clear();
            this.storage.clear();
            this.size = 0;
            StripeAwareLogManager.this.setDiskId(this.lastId);
        }

        @Override
        protected void append(LogManager.StableClosure done) {
            if (StripeAwareLogManager.this.stripe.size >= this.cap || StripeAwareLogManager.this.stripe.bufferSize >= StripeAwareLogManager.this.maxAppendBufferSize) {
                this.flush();
            }
            this.bufferSize = 0;
            super.append(done);
            StripeAwareLogManager.this.stripe.addBatcher(this, this.bufferSize);
        }
    }
}

