/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.node;

import com.fasterxml.jackson.annotation.JsonGetter;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Node version.")
public class NodeVersion {
    @Schema(description="Node version.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String version;
    @Schema(description="Node product.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String product;

    private NodeVersion(String version, String product) {
        this.version = version;
        this.product = product;
    }

    @JsonGetter(value="version")
    public String version() {
        return this.version;
    }

    @JsonGetter(value="product")
    public String product() {
        return this.product;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String version;
        private String product;

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder product(String product) {
            this.product = product;
            return this;
        }

        public NodeVersion build() {
            return new NodeVersion(this.version, this.product);
        }
    }
}

