/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema.marshaller.reflection;

import java.util.Objects;
import org.apache.ignite3.internal.marshaller.Marshaller;
import org.apache.ignite3.internal.marshaller.MarshallerSchema;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.marshaller.RecordMarshaller;
import org.apache.ignite3.internal.schema.marshaller.reflection.ObjectStatistics;
import org.apache.ignite3.internal.schema.marshaller.reflection.RowReader;
import org.apache.ignite3.internal.schema.marshaller.reflection.RowWriter;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.internal.schema.row.RowAssembler;
import org.apache.ignite3.lang.MarshallerException;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.PojoMapper;
import org.jetbrains.annotations.Nullable;

public class RecordMarshallerImpl<R>
implements RecordMarshaller<R> {
    private final SchemaDescriptor schema;
    private final Marshaller keyMarsh;
    private final Marshaller valMarsh;
    private final Marshaller recMarsh;
    private final Class<R> recClass;
    private final int[] keyPositions;

    public RecordMarshallerImpl(SchemaDescriptor schema, MarshallersProvider marshallers, Mapper<R> mapper) {
        assert (mapper instanceof PojoMapper);
        this.schema = schema;
        this.recClass = mapper.targetType();
        MarshallerSchema marshallerSchema = schema.marshallerSchema();
        this.keyMarsh = marshallers.getKeysMarshaller(marshallerSchema, mapper, true, true);
        this.valMarsh = marshallers.getValuesMarshaller(marshallerSchema, mapper, false, true);
        this.recMarsh = marshallers.getRowMarshaller(marshallerSchema, mapper, false, false);
        this.keyPositions = schema.keyColumns().stream().mapToInt(Column::positionInKey).toArray();
    }

    @Override
    public int schemaVersion() {
        return this.schema.version();
    }

    @Override
    public Row marshal(R rec) throws MarshallerException {
        assert (this.recClass.isInstance(rec));
        RowAssembler asm = this.createAssembler(Objects.requireNonNull(rec));
        this.recMarsh.writeObject(rec, new RowWriter(asm));
        return Row.wrapBinaryRow(this.schema, asm.build());
    }

    @Override
    public Row marshalKey(R rec) throws MarshallerException {
        assert (this.recClass.isInstance(rec));
        RowAssembler asm = this.createAssemblerForKey(Objects.requireNonNull(rec));
        this.keyMarsh.writeObject(rec, new RowWriter(asm));
        return Row.wrapKeyOnlyBinaryRow(this.schema, asm.build());
    }

    @Override
    public R unmarshal(Row row) throws MarshallerException {
        Marshaller marsh = row.keyOnly() ? this.keyMarsh : this.recMarsh;
        RowReader reader = row.keyOnly() ? new RowReader(row, this.keyPositions) : new RowReader(row);
        Object o = marsh.readObject(reader, null);
        assert (this.recClass.isInstance(o));
        return (R)o;
    }

    @Override
    @Nullable
    public Object value(Object obj, int fldIdx) {
        Column column = this.schema.column(fldIdx);
        return column.positionInKey() >= 0 ? this.keyMarsh.value(obj, column.positionInKey()) : this.valMarsh.value(obj, column.positionInValue());
    }

    private RowAssembler createAssemblerForKey(Object key) throws MarshallerException {
        try {
            return ObjectStatistics.createAssembler(this.schema, this.keyMarsh, key);
        }
        catch (Throwable e) {
            throw new MarshallerException(e.getMessage(), e);
        }
    }

    private RowAssembler createAssembler(Object rec) throws MarshallerException {
        try {
            return ObjectStatistics.createAssembler(this.schema, this.keyMarsh, this.valMarsh, rec, rec);
        }
        catch (Throwable e) {
            throw new MarshallerException(e.getMessage(), e);
        }
    }
}

