/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.ignite3.internal.sql.engine.util.cache.Cache;
import org.apache.ignite3.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite3.internal.sql.engine.util.cache.StatsCounter;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CaffeineCacheFactory
implements CacheFactory {
    public static final CacheFactory INSTANCE = new CaffeineCacheFactory();
    @Nullable
    private final Executor executor;

    private CaffeineCacheFactory() {
        this(null);
    }

    private CaffeineCacheFactory(@Nullable Executor executor) {
        this.executor = executor;
    }

    @TestOnly
    public static CacheFactory create(Executor executor) {
        return new CaffeineCacheFactory(executor);
    }

    @Override
    public <K, V> Cache<K, V> create(int size, StatsCounter statCounter) {
        return this.create(size, statCounter, null);
    }

    @Override
    public <K, V> Cache<K, V> create(int size, StatsCounter statCounter, Duration expireAfterAccess) {
        Caffeine builder = Caffeine.newBuilder().maximumSize((long)size);
        if (this.executor != null) {
            builder.executor(this.executor);
        }
        if (statCounter != null) {
            builder.recordStats(() -> new CaffeineStatsCounterAdapter(statCounter));
        }
        if (expireAfterAccess != null) {
            builder.expireAfterAccess(expireAfterAccess);
        }
        return new CaffeineCacheToCacheAdapter(builder.build());
    }

    @Override
    public <K, V> Cache<K, V> create(int size) {
        return this.create(size, null);
    }

    private static class CaffeineCacheToCacheAdapter<K, V>
    implements Cache<K, V> {
        private final com.github.benmanes.caffeine.cache.Cache<K, V> cache;

        private CaffeineCacheToCacheAdapter(com.github.benmanes.caffeine.cache.Cache<K, V> cache) {
            this.cache = cache;
        }

        @Override
        @Nullable
        public V get(K key) {
            return (V)this.cache.getIfPresent(key);
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> mappingFunction) {
            return (V)this.cache.get(key, mappingFunction);
        }

        @Override
        public void put(K key, V value) {
            this.cache.put(key, value);
        }

        @Override
        public void clear() {
            this.cache.invalidateAll();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return this.cache.asMap().compute(key, remappingFunction);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.cache.asMap().entrySet();
        }

        @Override
        public void removeIfValue(Predicate<? super V> valueFilter) {
            this.cache.asMap().values().removeIf(valueFilter);
        }

        @Override
        public void invalidate(K key) {
            this.cache.invalidate(key);
        }

        @Override
        public int size() {
            return this.cache.asMap().size();
        }
    }

    private static class CaffeineStatsCounterAdapter
    implements com.github.benmanes.caffeine.cache.stats.StatsCounter {
        private final StatsCounter statsCounter;

        private CaffeineStatsCounterAdapter(StatsCounter statsCounter) {
            this.statsCounter = statsCounter;
        }

        public void recordHits(@NonNegative int count) {
            this.statsCounter.recordHits(count);
        }

        public void recordMisses(@NonNegative int count) {
            this.statsCounter.recordMisses(count);
        }

        public void recordLoadSuccess(@NonNegative long loadTime) {
        }

        public void recordLoadFailure(@NonNegative long loadTime) {
        }

        public void recordEviction(@NonNegative int weight, RemovalCause cause) {
        }

        public CacheStats snapshot() {
            return null;
        }
    }
}

