/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.rocksdb.ColumnFamilyUtils;
import org.apache.ignite3.internal.storage.rocksdb.Index;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbMetaStorage;
import org.apache.ignite3.internal.storage.rocksdb.index.RocksDbSortedIndexStorage;
import org.apache.ignite3.internal.storage.rocksdb.instance.SharedRocksDbInstance;

class SortedIndex
extends Index<RocksDbSortedIndexStorage> {
    private final StorageSortedIndexDescriptor descriptor;
    private final RocksDbMetaStorage indexMetaStorage;

    private SortedIndex(int tableId, ColumnFamily indexCf, StorageSortedIndexDescriptor descriptor, RocksDbMetaStorage indexMetaStorage) {
        super(tableId, descriptor.id(), indexCf);
        this.descriptor = descriptor;
        this.indexMetaStorage = indexMetaStorage;
    }

    static SortedIndex createNew(SharedRocksDbInstance rocksDb, int tableId, StorageSortedIndexDescriptor descriptor, RocksDbMetaStorage indexMetaStorage) {
        ColumnFamily indexCf = rocksDb.getOrCreateSortedIndexCf(ColumnFamilyUtils.sortedIndexCfName(descriptor.columns()), descriptor.id(), tableId);
        return new SortedIndex(tableId, indexCf, descriptor, indexMetaStorage);
    }

    static SortedIndex restoreExisting(int tableId, ColumnFamily indexCf, StorageSortedIndexDescriptor descriptor, RocksDbMetaStorage indexMetaStorage) {
        return new SortedIndex(tableId, indexCf, descriptor, indexMetaStorage);
    }

    @Override
    RocksDbSortedIndexStorage createStorage(int partitionId) {
        return new RocksDbSortedIndexStorage(this.descriptor, this.tableId(), partitionId, this.columnFamily(), this.indexMetaStorage);
    }
}

