/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.disaster;

import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStateEnum;
import org.apache.ignite3.raft.jraft.Node;
import org.apache.ignite3.raft.jraft.core.State;

class LocalPartitionStateEnumWithLogIndex {
    final LocalPartitionStateEnum state;
    final long logIndex;

    private LocalPartitionStateEnumWithLogIndex(LocalPartitionStateEnum state, long logIndex) {
        this.state = state;
        this.logIndex = logIndex;
    }

    static LocalPartitionStateEnumWithLogIndex of(Node raftNode) {
        State nodeState = raftNode.getNodeState();
        LocalPartitionStateEnum localState = LocalPartitionStateEnum.convert(nodeState);
        long lastLogIndex = raftNode.lastLogIndex();
        if (localState == LocalPartitionStateEnum.HEALTHY) {
            if (lastLogIndex == 0L) {
                localState = LocalPartitionStateEnum.INITIALIZING;
            }
            if (raftNode.isInstallingSnapshot()) {
                localState = LocalPartitionStateEnum.INSTALLING_SNAPSHOT;
            }
        }
        return new LocalPartitionStateEnumWithLogIndex(localState, lastLogIndex);
    }
}

