/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util;

import org.apache.ignite3.internal.util.GridUnsafe;
import org.apache.ignite3.raft.jraft.util.HeapByteBufUtil;

public class Bits {
    public static int getInt(byte[] b, int off) {
        return HeapByteBufUtil.getInt(b, off);
    }

    public static long getLong(byte[] b, int off) {
        return HeapByteBufUtil.getLong(b, off);
    }

    public static void putInt(byte[] b, int off, int val) {
        HeapByteBufUtil.setInt(b, off, val);
    }

    public static void putShort(byte[] b, int off, short val) {
        HeapByteBufUtil.setShort(b, off, val);
    }

    public static short getShort(byte[] b, int off) {
        return HeapByteBufUtil.getShort(b, off);
    }

    public static void putLong(byte[] b, int off, long val) {
        HeapByteBufUtil.setLong(b, off, val);
    }

    public static void putShortLittleEndian(long addr, short value) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putShort(addr, Short.reverseBytes(value));
        } else {
            GridUnsafe.putShort(addr, value);
        }
    }

    public static void putShortLittleEndian(byte[] b, int off, short value) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putShort(b, GridUnsafe.BYTE_ARR_OFF + (long)off, Short.reverseBytes(value));
        } else {
            GridUnsafe.putShort(b, GridUnsafe.BYTE_ARR_OFF + (long)off, value);
        }
    }

    public static short getShortLittleEndian(byte[] b, int off) {
        short value = GridUnsafe.getShort(b, GridUnsafe.BYTE_ARR_OFF + (long)off);
        return GridUnsafe.IS_BIG_ENDIAN ? Short.reverseBytes(value) : value;
    }

    public static void putIntLittleEndian(long addr, int value) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putInt(addr, Integer.reverseBytes(value));
        } else {
            GridUnsafe.putInt(addr, value);
        }
    }

    public static void putLongLittleEndian(long addr, long value) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putLong(addr, Long.reverseBytes(value));
        } else {
            GridUnsafe.putLong(addr, value);
        }
    }

    public static void putLongLittleEndian(byte[] b, int off, long value) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putLong(b, GridUnsafe.BYTE_ARR_OFF + (long)off, Long.reverseBytes(value));
        } else {
            GridUnsafe.putLong(b, GridUnsafe.BYTE_ARR_OFF + (long)off, value);
        }
    }

    public static long getLongLittleEndian(byte[] b, int off) {
        long value = GridUnsafe.getLong(b, GridUnsafe.BYTE_ARR_OFF + (long)off);
        return GridUnsafe.IS_BIG_ENDIAN ? Long.reverseBytes(value) : value;
    }
}

