/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineIO;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;

public class InlineTreeFilterClosure
implements BPlusTree.TreeRowClosure<IndexRow, IndexRow> {
    private final IndexingQueryCacheFilter cacheFilter;
    private final BPlusTree.TreeRowClosure<IndexRow, IndexRow> rowFilter;

    public InlineTreeFilterClosure(IndexingQueryCacheFilter cacheFilter, BPlusTree.TreeRowClosure<IndexRow, IndexRow> rowFilter) {
        assert (cacheFilter != null || rowFilter != null);
        this.cacheFilter = cacheFilter;
        this.rowFilter = rowFilter;
    }

    @Override
    public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
        boolean val;
        boolean bl = val = this.cacheFilter == null || this.applyFilter((InlineIO)((Object)io), pageAddr, idx);
        if (!val) {
            return false;
        }
        if (this.rowFilter != null) {
            val = this.rowFilter.apply(tree, io, pageAddr, idx);
        }
        return val;
    }

    private boolean applyFilter(InlineIO io, long pageAddr, int idx) {
        assert (this.cacheFilter != null);
        return this.cacheFilter.applyPartition(PageIdUtils.partId(PageIdUtils.pageId(io.link(pageAddr, idx))));
    }

    public String toString() {
        return S.toString(InlineTreeFilterClosure.class, this);
    }
}

