/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateValueUtils {
    private static final ThreadLocal<Calendar> UTC_CALENDAR = ThreadLocal.withInitial(() -> Calendar.getInstance(TimeZone.getTimeZone("UTC")));
    private static final TimeZone DEFAULT_TZ = TimeZone.getDefault();
    private static final int SHIFT_YEAR = 9;
    private static final int SHIFT_MONTH = 5;
    private static final long MONTH_MASK = 15L;
    private static final long DAY_MASK = 31L;
    public static final long MIN_DATE_VALUE = -511999999455L;
    public static final long MAX_DATE_VALUE = 511999999903L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long NANOS_PER_DAY = 86400000000000L;

    private DateValueUtils() {
    }

    private static int yearFromDateValue(long dateVal) {
        return (int)(dateVal >>> 9);
    }

    private static int monthFromDateValue(long dateVal) {
        return (int)(dateVal >>> 5 & 0xFL);
    }

    private static int dayFromDateValue(long dateVal) {
        return (int)(dateVal & 0x1FL);
    }

    public static long dateValue(int year, int month, int day) {
        return (long)year << 9 | (long)(month << 5) | (long)day;
    }

    public static long millisFromDateValue(long dateVal) {
        Calendar cal = UTC_CALENDAR.get();
        cal.clear();
        cal.set(DateValueUtils.yearFromDateValue(dateVal), DateValueUtils.monthFromDateValue(dateVal) - 1, DateValueUtils.dayFromDateValue(dateVal));
        return cal.getTimeInMillis();
    }

    public static long dateValueFromMillis(long millis) {
        Calendar cal = UTC_CALENDAR.get();
        cal.setTimeInMillis(millis);
        return DateValueUtils.dateValue(cal.get(0) == 0 ? 1 - cal.get(1) : cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public static long utcMillisFromDefaultTz(long tzMillis) {
        return tzMillis + (long)DEFAULT_TZ.getOffset(tzMillis);
    }

    public static long defaultTzMillisFromUtc(long utcMillis) {
        return utcMillis - (long)DEFAULT_TZ.getOffset(utcMillis - (long)DEFAULT_TZ.getOffset(utcMillis));
    }

    public static Timestamp convertToTimestamp(LocalDateTime locDateTime) {
        LocalDate locDate = locDateTime.toLocalDate();
        LocalTime locTime = locDateTime.toLocalTime();
        long dateVal = DateValueUtils.dateValue(locDate.getYear(), locDate.getMonthValue(), locDate.getDayOfMonth());
        long millis = DateValueUtils.millisFromDateValue(dateVal) + TimeUnit.NANOSECONDS.toMillis(locTime.toNanoOfDay());
        long nanos = locTime.toNanoOfDay() % 1000000000L;
        Timestamp res = new Timestamp(DateValueUtils.defaultTzMillisFromUtc(millis));
        res.setNanos((int)nanos);
        return res;
    }

    public static Time convertToSqlTime(LocalTime locTime) {
        long millis = TimeUnit.NANOSECONDS.toMillis(locTime.toNanoOfDay());
        return new Time(DateValueUtils.defaultTzMillisFromUtc(millis));
    }

    public static Date convertToSqlDate(LocalDate locDate) {
        long dateVal = DateValueUtils.dateValue(locDate.getYear(), locDate.getMonthValue(), locDate.getDayOfMonth());
        long millis = DateValueUtils.millisFromDateValue(dateVal);
        return new Date(DateValueUtils.defaultTzMillisFromUtc(millis));
    }
}

