/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.worker;

import org.jetbrains.annotations.NotNull;

public abstract class CycleThread
extends Thread {
    private final long sleepInterval;

    protected CycleThread(@NotNull String name, long sleepInterval) {
        super(name);
        this.sleepInterval = sleepInterval;
    }

    @Override
    public final void run() {
        try {
            while (!this.isInterrupted()) {
                Thread.sleep(this.sleepInterval);
                this.iteration();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public abstract void iteration() throws InterruptedException;
}

