/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;

@IgniteCodeGeneratingFail
public class HandshakeMessage
implements Message {
    private static final long serialVersionUID = 0L;
    private static final int MESSAGE_SIZE = 32;
    public static final int MESSAGE_FULL_SIZE = 34;
    private UUID nodeId;
    private long rcvCnt;
    private long connectCnt;

    public HandshakeMessage() {
    }

    public HandshakeMessage(UUID nodeId, long connectCnt, long rcvCnt) {
        assert (nodeId != null);
        assert (rcvCnt >= 0L) : rcvCnt;
        this.nodeId = nodeId;
        this.connectCnt = connectCnt;
        this.rcvCnt = rcvCnt;
    }

    public int connectionIndex() {
        return 0;
    }

    public long connectCount() {
        return this.connectCnt;
    }

    public long received() {
        return this.rcvCnt;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public int getMessageSize() {
        return 34;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        if (buf.remaining() < 34) {
            return false;
        }
        TcpCommunicationSpi.writeMessageType(buf, this.directType());
        byte[] bytes = U.uuidToBytes(this.nodeId);
        assert (bytes.length == 16) : bytes.length;
        buf.put(bytes);
        buf.putLong(this.rcvCnt);
        buf.putLong(this.connectCnt);
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        if (buf.remaining() < 32) {
            return false;
        }
        byte[] nodeIdBytes = new byte[16];
        buf.get(nodeIdBytes);
        this.nodeId = U.bytesToUuid(nodeIdBytes, 0);
        this.rcvCnt = buf.getLong();
        this.connectCnt = buf.getLong();
        return true;
    }

    @Override
    public short directType() {
        return -3;
    }

    @Override
    public byte fieldsCount() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(HandshakeMessage.class, this);
    }
}

