/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.collector;

import java.util.Iterator;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.CollectorTraverser;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;

public abstract class MeasurementCollector<T>
extends CollectorTraverser<T> {
    public MeasurementCollector(IMNode startNode, PartialPath path) throws MetadataException {
        super(startNode, path);
        this.shouldTraverseTemplate = true;
    }

    public MeasurementCollector(IMNode startNode, PartialPath path, int limit, int offset) throws MetadataException {
        super(startNode, path, limit, offset);
        this.shouldTraverseTemplate = true;
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        if (!node.isMeasurement()) {
            return false;
        }
        if (this.hasLimit) {
            ++this.curOffset;
            if (this.curOffset < this.offset) {
                return true;
            }
        }
        this.collectMeasurement(node.getAsMeasurementMNode());
        if (this.hasLimit) {
            ++this.count;
        }
        return true;
    }

    protected abstract void collectMeasurement(IMeasurementMNode var1) throws MetadataException;

    protected MeasurementPath getCurrentMeasurementPathInTraverse(IMeasurementMNode currentNode) throws MetadataException {
        IMNode par = (IMNode)this.traverseContext.peek();
        Iterator nodes = this.traverseContext.descendingIterator();
        StringBuilder builder = new StringBuilder(((IMNode)nodes.next()).getName());
        while (nodes.hasNext()) {
            builder.append(".");
            builder.append(((IMNode)nodes.next()).getName());
        }
        if (builder.length() != 0) {
            builder.append(".");
        }
        builder.append(currentNode.getName());
        MeasurementPath retPath = new MeasurementPath(new PartialPath(builder.toString()), currentNode.getSchema());
        retPath.setUnderAlignedEntity(par.getAsEntityMNode().isAligned());
        return retPath;
    }
}

