/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.async;

import java.io.IOException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.IClientManager;
import org.apache.iotdb.cluster.client.async.AsyncBaseFactory;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.async.TAsyncMethodCall;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TNonblockingTransport;

public class AsyncMetaClient
extends TSMetaService.AsyncClient {
    private Node node;
    private ClientCategory category;
    private IClientManager clientManager;

    public AsyncMetaClient(TProtocolFactory protocolFactory, TAsyncClientManager clientManager, TNonblockingTransport transport) {
        super(protocolFactory, clientManager, transport);
    }

    public AsyncMetaClient(TProtocolFactory protocolFactory, TAsyncClientManager clientManager, Node node, ClientCategory category) throws IOException {
        super(protocolFactory, clientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)node.getInternalIp(), (int)ClientUtils.getPort(node, category), (int)ClusterConstant.getConnectionTimeoutInMS()));
        this.node = node;
        this.category = category;
    }

    public AsyncMetaClient(TProtocolFactory protocolFactory, TAsyncClientManager clientManager, Node node, ClientCategory category, IClientManager manager) throws IOException {
        this(protocolFactory, clientManager, node, category);
        this.clientManager = manager;
    }

    public void returnSelf() {
        if (this.clientManager != null) {
            this.clientManager.returnAsyncClient((RaftService.AsyncClient)this, this.node, this.category);
        }
    }

    public void onComplete() {
        super.onComplete();
        this.returnSelf();
    }

    public String toString() {
        return "Async" + this.category.getName() + "{node=" + this.node + ",port=" + ClientUtils.getPort(this.node, this.category) + '}';
    }

    public void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isReady() {
        try {
            this.checkReady();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValid() {
        return this.___transport != null;
    }

    TAsyncMethodCall<Object> getCurrMethod() {
        return this.___currentMethod;
    }

    public static class AsyncMetaClientFactory
    extends AsyncBaseFactory<Node, AsyncMetaClient> {
        public AsyncMetaClientFactory(TProtocolFactory protocolFactory, ClientCategory category) {
            super(protocolFactory, category);
        }

        public AsyncMetaClientFactory(TProtocolFactory protocolFactory, ClientCategory category, IClientManager clientManager) {
            super(protocolFactory, category, clientManager);
        }

        @Override
        public void activateObject(Node node, PooledObject<AsyncMetaClient> pooledObject) {
        }

        public void destroyObject(Node node, PooledObject<AsyncMetaClient> pooledObject) {
            ((AsyncMetaClient)((Object)pooledObject.getObject())).close();
        }

        public PooledObject<AsyncMetaClient> makeObject(Node node) throws Exception {
            TAsyncClientManager manager = this.managers[this.clientCnt.incrementAndGet() % this.managers.length];
            manager = manager == null ? new TAsyncClientManager() : manager;
            return new DefaultPooledObject((Object)new AsyncMetaClient(this.protocolFactory, manager, node, this.category, this.clientPoolManager));
        }

        @Override
        public void passivateObject(Node node, PooledObject<AsyncMetaClient> pooledObject) {
        }

        public boolean validateObject(Node node, PooledObject<AsyncMetaClient> pooledObject) {
            return pooledObject != null && ((AsyncMetaClient)((Object)pooledObject.getObject())).isValid();
        }
    }
}

