/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadDataPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class LoadDataOperator
extends Operator {
    private final String inputFilePath;
    private final String measureType;

    public LoadDataOperator(int tokenIntType, String inputFilePath, String measureType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.LOAD_DATA;
        this.inputFilePath = inputFilePath;
        this.measureType = measureType;
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public String getMeasureType() {
        return this.measureType;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) {
        return new LoadDataPlan(this.inputFilePath, this.measureType);
    }
}

