/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericHandler<T>
implements AsyncMethodCallback<T> {
    private static final Logger logger = LoggerFactory.getLogger(GenericHandler.class);
    private Node source;
    private AtomicReference<T> result;
    private Exception e;

    public GenericHandler(Node source, AtomicReference<T> result) {
        this.source = source;
        this.result = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(T response) {
        if (this.result != null) {
            AtomicReference<T> atomicReference = this.result;
            synchronized (atomicReference) {
                this.result.set(response);
                this.result.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception exception) {
        if (!(exception instanceof ConnectException)) {
            logger.error("Cannot receive result from {}", (Object)this.source, (Object)exception);
        } else {
            logger.warn("Cannot receive result from {} : {}", (Object)this.source, (Object)exception.getMessage());
        }
        if (this.result != null) {
            AtomicReference<T> atomicReference = this.result;
            synchronized (atomicReference) {
                this.result.notifyAll();
                this.e = exception;
            }
        }
    }

    public Exception getException() {
        return this.e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResult(long timeout) throws InterruptedException, TException {
        AtomicReference<T> atomicReference = this.result;
        synchronized (atomicReference) {
            if (this.result.get() == null && this.getException() == null) {
                this.result.wait(timeout);
            }
        }
        if (this.getException() != null) {
            throw new TException((Throwable)this.getException());
        }
        return this.result.get();
    }
}

