/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;

public class IsNullTransformer
extends UnaryTransformer {
    private final boolean isNot;

    public IsNullTransformer(LayerReader layerReader, boolean isNot) {
        super(layerReader);
        this.isNot = isNot;
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.BOOLEAN};
    }

    @Override
    protected void transform(Column[] columns, ColumnBuilder builder) throws QueryProcessException, IOException {
        int count = columns[0].getPositionCount();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            builder.writeBoolean(isNulls[i] ^ this.isNot);
        }
    }
}

