/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemChunkReader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;

public class MemChunkLoader
implements IChunkLoader {
    protected final QueryContext context;
    protected final ReadOnlyMemChunk chunk;
    protected final boolean streamingQueryMemChunk;
    protected static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public MemChunkLoader(QueryContext context, ReadOnlyMemChunk chunk) {
        this(context, chunk, false);
    }

    public MemChunkLoader(QueryContext context, ReadOnlyMemChunk chunk, boolean streamingQueryMemChunk) {
        this.context = context;
        this.chunk = chunk;
        this.streamingQueryMemChunk = streamingQueryMemChunk;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter globalTimeFilter) {
        long startTime = System.nanoTime();
        try {
            MemChunkReader memChunkReader = new MemChunkReader(this.chunk, globalTimeFilter);
            return memChunkReader;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            this.context.getQueryStatistics().getConstructNonAlignedChunkReadersMemCount().getAndAdd(1L);
            this.context.getQueryStatistics().getConstructNonAlignedChunkReadersMemTime().getAndAdd(duration);
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("init_chunk_reader_non_aligned_mem", duration);
        }
    }

    public ReadOnlyMemChunk getReadOnlyMemChunk() {
        return this.chunk;
    }

    public boolean isStreamingQueryMemChunk() {
        return this.streamingQueryMemChunk;
    }
}

