/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.table.v1.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.table.v1.model.QueryDataSet;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;

public class QueryDataSetHandler {
    private QueryDataSetHandler() {
    }

    public static Response fillQueryDataSet(IQueryExecution queryExecution, Statement statement, int actualRowSizeLimit) throws IoTDBException {
        if (statement instanceof Query) {
            return QueryDataSetHandler.fillQueryDataSet(queryExecution, actualRowSizeLimit);
        }
        return QueryDataSetHandler.fillOtherDataSet(queryExecution, actualRowSizeLimit);
    }

    public static Response fillQueryDataSet(IQueryExecution queryExecution, int actualRowSizeLimit) throws IoTDBException {
        QueryDataSet targetDataSet = new QueryDataSet();
        int fetched = 0;
        int columnNum = queryExecution.getOutputValueColumnCount();
        DatasetHeader header = queryExecution.getDatasetHeader();
        List<String> resultColumns = header.getRespColumns();
        List<TSDataType> dataTypes = header.getRespDataTypes();
        Map<String, Integer> headerMap = header.getColumnNameIndexMap();
        for (int i = 0; i < resultColumns.size(); ++i) {
            targetDataSet.addColumnNamesItem(resultColumns.get(i));
            targetDataSet.addDataTypesItem(dataTypes.get(i).name());
            targetDataSet.addValuesItem(new ArrayList());
        }
        block1: while (true) {
            if (0 < actualRowSizeLimit && actualRowSizeLimit <= fetched) {
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode())).message(String.format("Dataset row size exceeded the given max row size (%d)", actualRowSizeLimit))).build();
            }
            Optional<TsBlock> optionalTsBlock = queryExecution.getBatchResult();
            if (!optionalTsBlock.isPresent() || optionalTsBlock.get().isEmpty()) {
                if (fetched != 0) break;
                targetDataSet.setValues(new ArrayList());
                return Response.ok().entity((Object)targetDataSet).build();
            }
            TsBlock tsBlock = optionalTsBlock.get();
            int currentCount = tsBlock.getPositionCount();
            int k = 0;
            while (true) {
                if (k >= resultColumns.size()) continue block1;
                Column column = tsBlock.getColumn(headerMap.get(resultColumns.get(k)).intValue());
                List targetDataSetColumn = (List)targetDataSet.getValues().get(k);
                for (int i = 0; i < currentCount; ++i) {
                    ++fetched;
                    if (column.isNull(i)) {
                        targetDataSetColumn.add(null);
                        continue;
                    }
                    targetDataSetColumn.add(column.getDataType().equals((Object)TSDataType.TEXT) ? column.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET) : column.getObject(i));
                }
                if (k != columnNum - 1) {
                    fetched -= currentCount;
                }
                ++k;
            }
            break;
        }
        targetDataSet.setValues(QueryDataSetHandler.convertColumnToRow(targetDataSet.getValues()));
        return Response.ok().entity((Object)targetDataSet).build();
    }

    private static Response fillOtherDataSet(IQueryExecution queryExecution, int actualRowSizeLimit) throws IoTDBException {
        QueryDataSet targetDataSet = new QueryDataSet();
        int[] targetDataSetIndexToSourceDataSetIndex = new int[queryExecution.getDatasetHeader().getRespColumns().size()];
        QueryDataSetHandler.initTargetDatasetOrderByOrderWithSourceDataSet(queryExecution.getDatasetHeader(), targetDataSetIndexToSourceDataSetIndex, targetDataSet);
        return QueryDataSetHandler.fillOtherQueryDataSet(queryExecution, targetDataSetIndexToSourceDataSetIndex, actualRowSizeLimit, targetDataSet);
    }

    private static void initTargetDatasetOrderByOrderWithSourceDataSet(DatasetHeader datasetHeader, int[] targetDataSetIndexToSourceDataSetIndex, QueryDataSet targetDataSet) {
        if (datasetHeader.getRespColumns() != null) {
            for (int i = 0; i < datasetHeader.getRespColumns().size(); ++i) {
                targetDataSet.addColumnNamesItem(datasetHeader.getRespColumns().get(i));
                targetDataSet.addValuesItem(new ArrayList());
                targetDataSet.addDataTypesItem(datasetHeader.getRespDataTypes().get(i).name());
                targetDataSetIndexToSourceDataSetIndex[i] = i;
            }
        }
    }

    private static Response fillOtherQueryDataSet(IQueryExecution queryExecution, int[] targetDataSetIndexToSourceDataSetIndex, int actualRowSizeLimit, QueryDataSet targetDataSet) throws IoTDBException {
        int fetched = 0;
        int columnNum = queryExecution.getOutputValueColumnCount();
        block0: while (true) {
            if (0 < actualRowSizeLimit && actualRowSizeLimit <= fetched) {
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode())).message(String.format("Dataset row size exceeded the given max row size (%d)", actualRowSizeLimit))).build();
            }
            Optional<TsBlock> optionalTsBlock = queryExecution.getBatchResult();
            if (!optionalTsBlock.isPresent()) {
                if (fetched != 0) break;
                targetDataSet.setValues(new ArrayList());
                return Response.ok().entity((Object)targetDataSet).build();
            }
            TsBlock tsBlock = optionalTsBlock.get();
            int currentCount = tsBlock.getPositionCount();
            if (currentCount == 0) {
                targetDataSet.setValues(new ArrayList());
                return Response.ok().entity((Object)targetDataSet).build();
            }
            int k = 0;
            while (true) {
                if (k >= columnNum) continue block0;
                Column column = tsBlock.getColumn(targetDataSetIndexToSourceDataSetIndex[k]);
                List targetDataSetColumn = (List)targetDataSet.getValues().get(k);
                for (int i = 0; i < currentCount; ++i) {
                    ++fetched;
                    if (column.isNull(i)) {
                        targetDataSetColumn.add(null);
                        continue;
                    }
                    targetDataSetColumn.add(column.getDataType().equals((Object)TSDataType.TEXT) ? column.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET) : column.getObject(i));
                }
                if (k != columnNum - 1) {
                    fetched -= currentCount;
                }
                ++k;
            }
            break;
        }
        targetDataSet.setValues(QueryDataSetHandler.convertColumnToRow(targetDataSet.getValues()));
        return Response.ok().entity((Object)targetDataSet).build();
    }

    private static List<List<Object>> convertColumnToRow(List<List<Object>> values) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        if (values.isEmpty() || values.get(0).isEmpty()) {
            return result;
        }
        int numRows = values.get(0).size();
        for (int i = 0; i < numRows; ++i) {
            ArrayList<Object> newRow = new ArrayList<Object>();
            for (List<Object> value : values) {
                newRow.add(value.get(i));
            }
            result.add(newRow);
        }
        return result;
    }
}

