/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.type.AuthorRType;

public class RelationalAuthorStatement
extends Statement {
    private final AuthorRType authorType;
    private String tableName;
    private String database;
    private String userName;
    private String roleName;
    private String password;
    private Set<PrivilegeType> privilegeType;
    private boolean grantOption;

    public RelationalAuthorStatement(AuthorRType authorType, String userName, String roleName, String database, String table, Set<PrivilegeType> type, boolean grantOption, String password) {
        super(null);
        this.authorType = authorType;
        this.database = database;
        this.tableName = table;
        this.privilegeType = type;
        this.roleName = roleName;
        this.userName = userName;
        this.grantOption = grantOption;
        this.password = password;
    }

    public RelationalAuthorStatement(AuthorRType statementType) {
        super(null);
        this.authorType = statementType;
    }

    public RelationalAuthorStatement(AuthorRType statementType, Set<PrivilegeType> type, String userName, String roleName, boolean grantOption) {
        super(null);
        this.authorType = statementType;
        this.privilegeType = type;
        this.userName = userName;
        this.roleName = roleName;
        this.grantOption = grantOption;
        this.tableName = null;
        this.database = null;
        this.password = null;
    }

    public RelationalAuthorStatement(AuthorRType statementType, String userName, String roleName, boolean grantOption) {
        super(null);
        this.authorType = statementType;
        this.userName = userName;
        this.roleName = roleName;
        this.grantOption = grantOption;
    }

    public AuthorRType getAuthorType() {
        return this.authorType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isGrantOption() {
        return this.grantOption;
    }

    public Set<PrivilegeType> getPrivilegeTypes() {
        return this.privilegeType;
    }

    public String getPrivilegesString() {
        return this.privilegeType.stream().map(Enum::name).collect(Collectors.joining(","));
    }

    public Set<Integer> getPrivilegeIds() {
        HashSet<Integer> privilegeIds = new HashSet<Integer>();
        for (PrivilegeType privilegeType : this.privilegeType) {
            privilegeIds.add(privilegeType.ordinal());
        }
        return privilegeIds;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationalAuthorStatement that = (RelationalAuthorStatement)o;
        return this.grantOption == that.grantOption && this.authorType == that.authorType && Objects.equals(this.database, that.database) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.userName, that.userName) && Objects.equals(this.roleName, that.roleName) && Objects.equals(this.privilegeType, that.privilegeType) && Objects.equals(this.password, that.password);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRelationalAuthorPlan(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.authorType, this.database, this.tableName, this.privilegeType, this.userName, this.roleName, this.grantOption, this.password});
    }

    public QueryType getQueryType() {
        switch (this.authorType) {
            case CREATE_ROLE: 
            case CREATE_USER: 
            case DROP_ROLE: 
            case DROP_USER: 
            case UPDATE_USER: 
            case GRANT_ROLE_ANY: 
            case GRANT_USER_ANY: 
            case GRANT_ROLE_ALL: 
            case GRANT_USER_ALL: 
            case GRANT_ROLE_DB: 
            case GRANT_USER_DB: 
            case GRANT_ROLE_TB: 
            case GRANT_USER_TB: 
            case GRANT_USER_ROLE: 
            case GRANT_USER_SYS: 
            case GRANT_ROLE_SYS: 
            case REVOKE_ROLE_DB: 
            case REVOKE_USER_DB: 
            case REVOKE_ROLE_TB: 
            case REVOKE_USER_TB: 
            case REVOKE_ROLE_ANY: 
            case REVOKE_USER_ANY: 
            case REVOKE_ROLE_ALL: 
            case REVOKE_USER_ALL: 
            case REVOKE_ROLE_SYS: 
            case REVOKE_USER_SYS: 
            case REVOKE_USER_ROLE: {
                return QueryType.WRITE;
            }
            case LIST_ROLE: 
            case LIST_USER: 
            case LIST_ROLE_PRIV: 
            case LIST_USER_PRIV: {
                return QueryType.READ;
            }
        }
        throw new IllegalArgumentException("Unknown authorType:" + (Object)((Object)this.authorType));
    }

    @Override
    public String toString() {
        return "auth statement: " + (Object)((Object)this.authorType) + "to Database: " + this.database + "." + this.tableName + ", user name: " + this.userName + ", role name: " + this.roleName + ", privileges:" + this.privilegeType + ", grantOption:" + this.grantOption;
    }
}

