/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class DropPipePlanV2
extends ConfigPhysicalPlan {
    private String pipeName;

    public DropPipePlanV2() {
        super(ConfigPhysicalPlanType.DropPipeV2);
    }

    public DropPipePlanV2(String pipeName) {
        super(ConfigPhysicalPlanType.DropPipeV2);
        this.pipeName = pipeName;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        BasicStructureSerDeUtil.write((String)this.pipeName, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.pipeName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropPipePlanV2 that = (DropPipePlanV2)obj;
        return this.pipeName.equals(that.pipeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pipeName);
    }

    public String toString() {
        return "DropPipePlanV2{pipeName='" + this.pipeName + "'}";
    }
}

