/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils;

import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.tsfile.file.metadata.IDeviceID;

public class CompactionPathUtils {
    private CompactionPathUtils() {
    }

    public static PartialPath getPath(IDeviceID device, String measurement) throws IllegalPathException {
        if (device.isTableModel()) {
            String[] tableNameSegments = DataNodeDevicePathCache.getInstance().getPartialPath(device.getTableName()).getNodes();
            String[] nodes = new String[device.segmentNum() + tableNameSegments.length];
            System.arraycopy(tableNameSegments, 0, nodes, 0, tableNameSegments.length);
            for (int i = 0; i < device.segmentNum() - 1; ++i) {
                nodes[i + tableNameSegments.length] = device.segment(i + 1) == null ? null : device.segment(i + 1).toString();
            }
            nodes[device.segmentNum() + tableNameSegments.length - 1] = measurement;
            MeasurementPath path = new MeasurementPath(nodes);
            path.setDevice(device);
            return path;
        }
        return DataNodeDevicePathCache.getInstance().getPartialPath(device.toString()).concatAsMeasurementPath(measurement);
    }
}

