/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.payload;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessageHandler;
import org.apache.iotdb.session.subscription.payload.SubscriptionSessionDataSet;
import org.apache.tsfile.write.record.Tablet;

public class SubscriptionSessionDataSetsHandler
implements Iterable<SubscriptionSessionDataSet>,
SubscriptionMessageHandler {
    private final Map<String, List<Tablet>> tablets;

    public SubscriptionSessionDataSetsHandler(Map<String, List<Tablet>> tablets) {
        this.tablets = tablets;
    }

    @Override
    public Iterator<SubscriptionSessionDataSet> iterator() {
        return new Iterator<SubscriptionSessionDataSet>(){
            private final Iterator<Map.Entry<String, List<Tablet>>> entryIterator;
            private String currentDatabase;
            private Iterator<Tablet> tabletIterator;
            {
                this.entryIterator = SubscriptionSessionDataSetsHandler.this.tablets.entrySet().iterator();
                this.tabletIterator = Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                while (!this.tabletIterator.hasNext() && this.entryIterator.hasNext()) {
                    Map.Entry<String, List<Tablet>> entry = this.entryIterator.next();
                    this.currentDatabase = entry.getKey();
                    List<Tablet> list = entry.getValue();
                    this.tabletIterator = list != null ? list.iterator() : Collections.emptyIterator();
                }
                return this.tabletIterator.hasNext();
            }

            @Override
            public SubscriptionSessionDataSet next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Tablet tablet = this.tabletIterator.next();
                return new SubscriptionSessionDataSet(tablet, this.currentDatabase);
            }
        };
    }

    public Iterator<Tablet> tabletIterator() {
        return new Iterator<Tablet>(){
            final Iterator<SubscriptionSessionDataSet> iterator;
            {
                this.iterator = SubscriptionSessionDataSetsHandler.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Tablet next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.iterator.next().getTablet();
            }
        };
    }
}

