/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jsieve.Argument;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.Block;
import org.apache.jsieve.Command;
import org.apache.jsieve.Commands;
import org.apache.jsieve.ScriptCoordinate;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.Test;
import org.apache.jsieve.TestList;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.parser.generated.ASTargument;
import org.apache.jsieve.parser.generated.ASTarguments;
import org.apache.jsieve.parser.generated.ASTblock;
import org.apache.jsieve.parser.generated.ASTcommand;
import org.apache.jsieve.parser.generated.ASTcommands;
import org.apache.jsieve.parser.generated.ASTstart;
import org.apache.jsieve.parser.generated.ASTstring;
import org.apache.jsieve.parser.generated.ASTstring_list;
import org.apache.jsieve.parser.generated.ASTtest;
import org.apache.jsieve.parser.generated.ASTtest_list;
import org.apache.jsieve.parser.generated.SieveParserVisitor;
import org.apache.jsieve.parser.generated.SimpleNode;

public class SieveParserVisitorImpl
implements SieveParserVisitor {
    private final SieveContext context;

    public SieveParserVisitorImpl(SieveContext context) {
        this.context = context;
    }

    protected Object visitChildren(SimpleNode node, Object data) throws SieveException {
        ArrayList children = new ArrayList(node.jjtGetNumChildren());
        node.childrenAccept(this, children);
        ((List)data).addAll(children);
        return data;
    }

    @Override
    public Object visit(ASTargument node, Object data) throws SieveException {
        ArrayList children = new ArrayList(node.jjtGetNumChildren());
        Argument argument = null != node.getValue() ? (Argument)node.getValue() : new StringListArgument((List)node.childrenAccept(this, children));
        ((List)data).add(argument);
        return data;
    }

    @Override
    public Object visit(ASTarguments node, Object data) throws SieveException {
        List children = new ArrayList(node.jjtGetNumChildren());
        children = (List)node.childrenAccept(this, children);
        Iterator childrenIter = children.iterator();
        TestList testList = null;
        ArrayList<Argument> argList = new ArrayList<Argument>(children.size());
        while (childrenIter.hasNext()) {
            Object next = childrenIter.next();
            if (next instanceof Test) {
                testList = new TestList((Test)next);
                continue;
            }
            if (next instanceof TestList) {
                testList = (TestList)next;
                continue;
            }
            if (next instanceof Argument) {
                argList.add((Argument)next);
                continue;
            }
            this.context.getLog().error((Object)("Expected an 'Argument' but was " + next));
        }
        Arguments arguments = new Arguments(argList, testList);
        ((List)data).add(arguments);
        return data;
    }

    @Override
    public Object visit(ASTblock node, Object data) throws SieveException {
        ArrayList children = new ArrayList(node.jjtGetNumChildren());
        Commands commands = (Commands)((List)node.childrenAccept(this, children)).get(0);
        Block block = new Block(commands);
        ((List)data).add(block);
        return data;
    }

    @Override
    public Object visit(ASTcommand node, Object data) throws SieveException {
        List children = new ArrayList(node.jjtGetNumChildren());
        children = (List)node.childrenAccept(this, children);
        Iterator childrenIter = children.iterator();
        Arguments arguments = null;
        Block block = null;
        while (childrenIter.hasNext()) {
            Object next = childrenIter.next();
            if (next instanceof Arguments) {
                arguments = (Arguments)next;
                continue;
            }
            if (!(next instanceof Block)) continue;
            block = (Block)next;
        }
        this.context.setCoordinate(node.getCoordinate());
        ScriptCoordinate coordinate = this.context.getCoordinate();
        Command command = new Command(node.getName(), arguments, block, coordinate);
        ((List)data).add(command);
        return data;
    }

    @Override
    public Object visit(ASTcommands node, Object data) throws SieveException {
        ArrayList children = new ArrayList(node.jjtGetNumChildren());
        Commands commands = new Commands((List)node.childrenAccept(this, children));
        ((List)data).add(commands);
        return data;
    }

    @Override
    public Object visit(ASTstart node, Object data) throws SieveException {
        if (!(data instanceof MailAdapter)) {
            throw new SieveException("Expecting an instance of " + MailAdapter.class.getName() + " as data, received an instance of " + (data == null ? "<null>" : data.getClass().getName()) + ".");
        }
        ArrayList children = new ArrayList(node.jjtGetNumChildren());
        Commands commands = (Commands)((List)node.childrenAccept(this, children)).get(0);
        Block block = new Block(commands);
        this.context.setCoordinate(node.getCoordinate());
        return block.execute((MailAdapter)data, this.context);
    }

    @Override
    public Object visit(ASTstring_list node, Object data) throws SieveException {
        return this.visitChildren(node, data);
    }

    @Override
    public Object visit(ASTstring node, Object data) {
        String value = (String)node.getValue();
        ((List)data).add(value);
        return data;
    }

    @Override
    public Object visit(ASTtest_list node, Object data) throws SieveException {
        ArrayList children = new ArrayList(node.jjtGetNumChildren());
        TestList testList = new TestList((List)node.childrenAccept(this, children));
        ((List)data).add(testList);
        return data;
    }

    @Override
    public Object visit(ASTtest node, Object data) throws SieveException {
        List children = new ArrayList(node.jjtGetNumChildren());
        children = (List)node.childrenAccept(this, children);
        Iterator childrenIter = children.iterator();
        Arguments arguments = null;
        while (childrenIter.hasNext()) {
            Object next = childrenIter.next();
            if (!(next instanceof Arguments)) continue;
            arguments = (Arguments)next;
        }
        this.context.setCoordinate(node.getCoordinate());
        Test test = new Test(node.getName(), arguments);
        ((List)data).add(test);
        return data;
    }

    @Override
    public Object visit(SimpleNode node, Object data) throws SieveException {
        return this.visitChildren(node, data);
    }
}

