/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;

public class ParsedMin
extends ParsedSingleValueNumericMetricsAggregation
implements Min {
    private static final ObjectParser<ParsedMin, Void> PARSER = new ObjectParser(ParsedMin.class.getSimpleName(), true, ParsedMin::new);

    @Override
    public double getValue() {
        return this.value();
    }

    @Override
    public String getType() {
        return "min";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        return builder;
    }

    public static ParsedMin fromXContent(XContentParser parser, String name) {
        ParsedMin min = (ParsedMin)PARSER.apply(parser, null);
        min.setName(name);
        return min;
    }

    static {
        ParsedMin.declareSingleValueFields(PARSER, Double.POSITIVE_INFINITY);
    }
}

