/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class StemmerTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final String language;
    public static final JsonpDeserializer<StemmerTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StemmerTokenFilter::setupStemmerTokenFilterDeserializer);

    private StemmerTokenFilter(Builder builder) {
        super(builder);
        this.language = ApiTypeHelper.requireNonNull(builder.language, this, "language");
    }

    public static StemmerTokenFilter of(Function<Builder, ObjectBuilder<StemmerTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Stemmer;
    }

    public final String language() {
        return this.language;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "stemmer");
        super.serializeInternal(generator, mapper);
        generator.writeKey("language");
        generator.write(this.language);
    }

    protected static void setupStemmerTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::language, JsonpDeserializer.stringDeserializer(), "language");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StemmerTokenFilter> {
        private String language;

        public final Builder language(String value) {
            this.language = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StemmerTokenFilter build() {
            this._checkSingleUse();
            return new StemmerTokenFilter(this);
        }
    }
}

