/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.message.BytesBackedLiteral;
import org.apache.james.imap.message.Literal;
import org.apache.james.imap.utils.EolInputStream;
import org.apache.james.imapserver.netty.AbstractNettyImapRequestLineReader;

public class NettyImapRequestLineReader
extends AbstractNettyImapRequestLineReader {
    public static final int MAXIMUM_LITERAL_COUNT = Optional.ofNullable(System.getProperty("james.imap.literal.count.max")).map(Integer::parseInt).orElse(64);
    private final int initialReaderIndex;
    private final ByteBuf buffer;
    private int read = 0;
    private int literalCount = 0;
    private final int maxLiteralSize;
    private final int maxFrameLength;

    public NettyImapRequestLineReader(Channel channel, ByteBuf buffer, boolean retry, int initialReaderIndex, int maxLiteralSize, int maxFrameLength) {
        super(channel, retry);
        this.buffer = buffer;
        this.initialReaderIndex = initialReaderIndex;
        this.maxLiteralSize = maxLiteralSize;
        this.maxFrameLength = maxFrameLength;
    }

    public char nextChar() throws DecodingException {
        if (!this.nextSeen) {
            if (this.buffer.isReadable()) {
                this.nextChar = (char)this.buffer.readByte();
                ++this.read;
                this.nextSeen = true;
                if (this.read > this.maxFrameLength) {
                    throw new DecodingException(HumanReadableText.FAILED, "Line length exceeded.");
                }
            } else {
                throw new NotEnoughDataException();
            }
        }
        return this.nextChar;
    }

    public Literal read(int size, boolean extraCRLF) throws DecodingException {
        int crlf = 0;
        if (extraCRLF) {
            crlf = 2;
        }
        int readSoFar = this.buffer.readerIndex() - this.initialReaderIndex;
        if (this.literalCount > MAXIMUM_LITERAL_COUNT) {
            throw new DecodingException(HumanReadableText.FAILED_LITERAL_SIZE_EXCEEDED, "Too many literals. " + MAXIMUM_LITERAL_COUNT + " allowed but got " + this.literalCount);
        }
        ++this.literalCount;
        if (this.maxLiteralSize > 0 && readSoFar + size > this.maxLiteralSize) {
            throw new DecodingException(HumanReadableText.FAILED_LITERAL_SIZE_EXCEEDED, "Specified literals total size is greater then the allowed size. " + (readSoFar + size) + " instead of " + this.maxLiteralSize + " limit.");
        }
        if (size + crlf > this.buffer.readableBytes()) {
            throw new NotEnoughDataException(size + this.read + crlf);
        }
        this.nextSeen = false;
        this.nextChar = '\u0000';
        try {
            BoundedInputStream in = new BoundedInputStream((InputStream)new ByteBufInputStream(this.buffer), (long)size);
            if (extraCRLF) {
                return BytesBackedLiteral.copy((InputStream)new EolInputStream((ImapRequestLineReader)this, (InputStream)in), (int)size);
            }
            return BytesBackedLiteral.copy((InputStream)in, (int)size);
        }
        catch (IOException e) {
            throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Can not read literal", (Throwable)e);
        }
    }

    public static final class NotEnoughDataException
    extends RuntimeException {
        public static final int UNKNOWN_SIZE = -1;
        private static final String NO_MESSAGE = null;
        private static final Throwable NO_CAUSE = null;
        private static final boolean DISABLE_SUPPRESSION = false;
        private final int size;

        public NotEnoughDataException(int size) {
            super(NO_MESSAGE, NO_CAUSE, false, false);
            this.size = size;
        }

        public NotEnoughDataException() {
            this(-1);
        }

        public int getNeededSize() {
            return this.size;
        }
    }
}

