/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.jwt.JsonUtil;
import com.google.crypto.tink.jwt.JwtFormat;
import com.google.crypto.tink.jwt.JwtPublicKeyVerifyInternal;
import com.google.crypto.tink.jwt.JwtValidator;
import com.google.crypto.tink.jwt.RawJwt;
import com.google.crypto.tink.jwt.VerifiedJwt;
import com.google.crypto.tink.proto.JwtRsaSsaPkcs1Algorithm;
import com.google.crypto.tink.proto.JwtRsaSsaPkcs1PublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.RsaSsaPkcs1VerifyJce;
import com.google.crypto.tink.subtle.Validators;
import com.google.gson.JsonObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Optional;

class JwtRsaSsaPkcs1VerifyKeyManager
extends KeyTypeManager<JwtRsaSsaPkcs1PublicKey> {
    public static Enums.HashType hashForPkcs1Algorithm(JwtRsaSsaPkcs1Algorithm algorithm) throws GeneralSecurityException {
        switch (algorithm) {
            case RS256: {
                return Enums.HashType.SHA256;
            }
            case RS384: {
                return Enums.HashType.SHA384;
            }
            case RS512: {
                return Enums.HashType.SHA512;
            }
        }
        throw new GeneralSecurityException("unknown algorithm " + algorithm.name());
    }

    private static final RSAPublicKey createPublicKey(JwtRsaSsaPkcs1PublicKey keyProto) throws GeneralSecurityException {
        KeyFactory kf = EngineFactory.KEY_FACTORY.getInstance("RSA");
        BigInteger modulus = new BigInteger(1, keyProto.getN().toByteArray());
        BigInteger exponent = new BigInteger(1, keyProto.getE().toByteArray());
        return (RSAPublicKey)kf.generatePublic(new RSAPublicKeySpec(modulus, exponent));
    }

    public JwtRsaSsaPkcs1VerifyKeyManager() {
        super(JwtRsaSsaPkcs1PublicKey.class, new PrimitiveFactory<JwtPublicKeyVerifyInternal, JwtRsaSsaPkcs1PublicKey>(JwtPublicKeyVerifyInternal.class){

            @Override
            public JwtPublicKeyVerifyInternal getPrimitive(JwtRsaSsaPkcs1PublicKey keyProto) throws GeneralSecurityException {
                RSAPublicKey publickey = JwtRsaSsaPkcs1VerifyKeyManager.createPublicKey(keyProto);
                Enums.HashType hash = JwtRsaSsaPkcs1VerifyKeyManager.hashForPkcs1Algorithm(keyProto.getAlgorithm());
                final RsaSsaPkcs1VerifyJce verifier = new RsaSsaPkcs1VerifyJce(publickey, hash);
                final String algorithmName = keyProto.getAlgorithm().name();
                final Optional customKidFromRsaSsaPkcs1PublicKey = keyProto.hasCustomKid() ? Optional.of(keyProto.getCustomKid().getValue()) : Optional.empty();
                return new JwtPublicKeyVerifyInternal(){

                    @Override
                    public VerifiedJwt verifyAndDecodeWithKid(String compact, JwtValidator validator, Optional<String> kid) throws GeneralSecurityException {
                        JwtFormat.Parts parts = JwtFormat.splitSignedCompact(compact);
                        verifier.verify(parts.signatureOrMac, parts.unsignedCompact.getBytes(StandardCharsets.US_ASCII));
                        JsonObject parsedHeader = JsonUtil.parseJson(parts.header);
                        JwtFormat.validateHeader(algorithmName, kid, customKidFromRsaSsaPkcs1PublicKey, parsedHeader);
                        RawJwt token = RawJwt.fromJsonPayload(JwtFormat.getTypeHeader(parsedHeader), parts.payload);
                        return validator.validate(token);
                    }
                };
            }
        });
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.JwtRsaSsaPkcs1PublicKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC;
    }

    @Override
    public JwtRsaSsaPkcs1PublicKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return JwtRsaSsaPkcs1PublicKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void validateKey(JwtRsaSsaPkcs1PublicKey pubKey) throws GeneralSecurityException {
        Validators.validateVersion(pubKey.getVersion(), this.getVersion());
        Validators.validateRsaModulusSize(new BigInteger(1, pubKey.getN().toByteArray()).bitLength());
        Validators.validateRsaPublicExponent(new BigInteger(1, pubKey.getE().toByteArray()));
    }
}

