/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers.dlp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.transport.matchers.dlp.DlpRulesLoader;
import org.apache.james.util.DurationParser;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class Dlp
extends GenericMatcher {
    private static final AttributeName DLP_MATCHED_RULE = AttributeName.of((String)"DlpMatchedRule");
    public static final String CACHE_PREFIX = "cache:";
    private final DlpRulesLoader backendRulesLoader;
    private final GaugeRegistry gaugeRegistry;
    private DlpRulesLoader rulesLoader;

    @VisibleForTesting
    Dlp(DlpRulesLoader rulesLoader, GaugeRegistry gaugeRegistry) {
        this.backendRulesLoader = rulesLoader;
        this.gaugeRegistry = gaugeRegistry;
        this.rulesLoader = this.backendRulesLoader;
    }

    @Inject
    public Dlp(DLPConfigurationStore configurationStore, GaugeRegistry gaugeRegistry) {
        this(new DlpRulesLoader.Impl(configurationStore), gaugeRegistry);
    }

    public void init() throws MessagingException {
        if (this.getCondition() != null && this.getCondition().startsWith(CACHE_PREFIX)) {
            this.rulesLoader = new DlpRulesLoader.Caching(this.backendRulesLoader, this.gaugeRegistry, DurationParser.parse((String)this.getCondition().substring(CACHE_PREFIX.length()), (ChronoUnit)ChronoUnit.SECONDS));
        }
    }

    public Collection<MailAddress> match(Mail mail) {
        Optional<DLPConfigurationItem.Id> firstMatchingRuleId = this.findFirstMatchingRule(mail);
        if (firstMatchingRuleId.isPresent()) {
            DLPConfigurationItem.Id ruleId = firstMatchingRuleId.get();
            this.setRuleIdAsMailAttribute(mail, ruleId);
            return mail.getRecipients();
        }
        return ImmutableList.of();
    }

    private void setRuleIdAsMailAttribute(Mail mail, DLPConfigurationItem.Id ruleId) {
        mail.setAttribute(new Attribute(DLP_MATCHED_RULE, AttributeValue.of((String)ruleId.asString())));
    }

    private Optional<DLPConfigurationItem.Id> findFirstMatchingRule(Mail mail) {
        return mail.getMaybeSender().asOptional().flatMap(sender -> this.matchingRule((MailAddress)sender, mail));
    }

    private Optional<DLPConfigurationItem.Id> matchingRule(MailAddress address, Mail mail) {
        return this.rulesLoader.load(address.getDomain()).match(mail);
    }

    public String getMatcherInfo() {
        return "Data Leak Prevention Matcher";
    }
}

