/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.incubator.quic;

import java.util.Objects;

public final class QuicInitialSettingsSpec {
    final long maxData;
    final long maxStreamDataBidirectionalLocal;
    final long maxStreamDataBidirectionalRemote;
    final long maxStreamDataUnidirectional;
    final long maxStreamsBidirectional;
    final long maxStreamsUnidirectional;

    QuicInitialSettingsSpec(Build build) {
        this.maxData = build.maxData;
        this.maxStreamDataBidirectionalLocal = build.maxStreamDataBidirectionalLocal;
        this.maxStreamDataBidirectionalRemote = build.maxStreamDataBidirectionalRemote;
        this.maxStreamDataUnidirectional = build.maxStreamDataUnidirectional;
        this.maxStreamsBidirectional = build.maxStreamsBidirectional;
        this.maxStreamsUnidirectional = build.maxStreamsUnidirectional;
    }

    public long maxData() {
        return this.maxData;
    }

    public long maxStreamDataBidirectionalLocal() {
        return this.maxStreamDataBidirectionalLocal;
    }

    public long maxStreamDataBidirectionalRemote() {
        return this.maxStreamDataBidirectionalRemote;
    }

    public long maxStreamDataUnidirectional() {
        return this.maxStreamDataUnidirectional;
    }

    public long maxStreamsBidirectional() {
        return this.maxStreamsBidirectional;
    }

    public long maxStreamsUnidirectional() {
        return this.maxStreamsUnidirectional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuicInitialSettingsSpec)) {
            return false;
        }
        QuicInitialSettingsSpec that = (QuicInitialSettingsSpec)o;
        return this.maxData == that.maxData && this.maxStreamDataBidirectionalLocal == that.maxStreamDataBidirectionalLocal && this.maxStreamDataBidirectionalRemote == that.maxStreamDataBidirectionalRemote && this.maxStreamDataUnidirectional == that.maxStreamDataUnidirectional && this.maxStreamsBidirectional == that.maxStreamsBidirectional && this.maxStreamsUnidirectional == that.maxStreamsUnidirectional;
    }

    public int hashCode() {
        return Objects.hash(this.maxData, this.maxStreamDataBidirectionalLocal, this.maxStreamDataBidirectionalRemote, this.maxStreamDataUnidirectional, this.maxStreamsBidirectional, this.maxStreamsUnidirectional);
    }

    static final class Build
    implements Builder {
        static final long DEFAULT_MAX_DATA = 0L;
        static final long DEFAULT_MAX_STREAM_DATA_BIDIRECTIONAL_LOCAL = 0L;
        static final long DEFAULT_MAX_STREAM_DATA_BIDIRECTIONAL_REMOTE = 0L;
        static final long DEFAULT_MAX_STREAM_DATA_UNIDIRECTIONAL = 0L;
        static final long DEFAULT_MAX_STREAM_BIDIRECTIONAL = 0L;
        static final long DEFAULT_MAX_STREAM_UNIDIRECTIONAL = 0L;
        long maxData = 0L;
        long maxStreamDataBidirectionalLocal = 0L;
        long maxStreamDataBidirectionalRemote = 0L;
        long maxStreamDataUnidirectional = 0L;
        long maxStreamsBidirectional = 0L;
        long maxStreamsUnidirectional = 0L;

        Build() {
        }

        QuicInitialSettingsSpec build() {
            return new QuicInitialSettingsSpec(this);
        }

        @Override
        public Builder maxData(long maxData) {
            if (maxData < 0L) {
                throw new IllegalArgumentException("maxData must be positive or zero");
            }
            this.maxData = maxData;
            return this;
        }

        @Override
        public Builder maxStreamDataBidirectionalLocal(long maxStreamDataBidirectionalLocal) {
            if (maxStreamDataBidirectionalLocal < 0L) {
                throw new IllegalArgumentException("maxStreamDataBidirectionalLocal must be positive or zero");
            }
            this.maxStreamDataBidirectionalLocal = maxStreamDataBidirectionalLocal;
            return this;
        }

        @Override
        public Builder maxStreamDataBidirectionalRemote(long maxStreamDataBidirectionalRemote) {
            if (maxStreamDataBidirectionalRemote < 0L) {
                throw new IllegalArgumentException("maxStreamDataBidirectionalRemote must be positive or zero");
            }
            this.maxStreamDataBidirectionalRemote = maxStreamDataBidirectionalRemote;
            return this;
        }

        @Override
        public Builder maxStreamDataUnidirectional(long maxStreamDataUnidirectional) {
            if (maxStreamDataUnidirectional < 0L) {
                throw new IllegalArgumentException("maxStreamDataUnidirectional must be positive or zero");
            }
            this.maxStreamDataUnidirectional = maxStreamDataUnidirectional;
            return this;
        }

        @Override
        public Builder maxStreamsBidirectional(long maxStreamsBidirectional) {
            if (maxStreamsBidirectional < 0L) {
                throw new IllegalArgumentException("maxStreamsBidirectional must be positive or zero");
            }
            this.maxStreamsBidirectional = maxStreamsBidirectional;
            return this;
        }

        @Override
        public Builder maxStreamsUnidirectional(long maxStreamsUnidirectional) {
            if (maxStreamsUnidirectional < 0L) {
                throw new IllegalArgumentException("maxStreamsUnidirectional must be positive or zero");
            }
            this.maxStreamsUnidirectional = maxStreamsUnidirectional;
            return this;
        }
    }

    public static interface Builder {
        public Builder maxData(long var1);

        public Builder maxStreamDataBidirectionalLocal(long var1);

        public Builder maxStreamDataBidirectionalRemote(long var1);

        public Builder maxStreamDataUnidirectional(long var1);

        public Builder maxStreamsBidirectional(long var1);

        public Builder maxStreamsUnidirectional(long var1);
    }
}

