/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { Config, DomQuery, DQ } from "mona-dish";
import { XhrFormData } from "./XhrFormData";
/**
 * Resolver functions for various aspects of the request data
 *
 * stateless because it might be called from various
 * parts of the response classes
 */
/**
 * resolves the event handlers lazily
 * so that if some decoration happens in between we can deal with it
 *
 * @param requestContext
 * @param responseContext
 * @param funcName
 */
export declare function resolveHandlerFunc(requestContext: Config, responseContext: Config, funcName: string): any;
export declare function resolveTargetUrl(srcFormElement: HTMLFormElement): any;
export declare function resolveFinalUrl(sourceForm: DomQuery, formData: XhrFormData, ajaxType?: string): string;
/**
 * form resolution the same way our old implementation did
 * it is either the id or the parent form of the element or an embedded form
 * of the element
 *
 * @param elem
 * @param event
 */
export declare function resolveForm(elem: DQ, event: Event): DQ;
export declare function resolveViewId(form: DQ): string;
export declare function resolveViewRootId(form: DQ): string;
/**
 * as per jsdoc before the request it must be ensured that every post argument
 * is prefixed with the naming container id (there is an exception in mojarra with
 * the element=element param, which we have to follow here as well.
 * (inputs are prefixed by name anyway normally this only affects our standard parameters)
 * @private
 */
export declare function resoveNamingContainerMapper(internalContext: Config): (key: string, value: any) => [string, any];
export declare function resolveTimeout(options: Config): number;
/**
 * resolve the delay from the options and/or the request context and or the configuration
 *
 * @param options ... the options object, in most cases it will host the delay value
 */
export declare function resolveDelay(options: Config): number;
/**
 * resolves the window-id from various sources
 *
 * @param options
 */
export declare function resolveWindowId(options: Config): any;
/**
 * cross port from the dojo lib
 * browser save event resolution
 * @param evt the event object
 * (with a fallback for ie events if none is present)
 * @deprecated soon will be removed
 */
export declare function getEventTarget(evt: Event): Element;
/**
 * resolves a bunch of default values
 * which can be further processed from the given
 * call parameters of faces.ajax.request
 *
 * @param event
 * @param opts
 * @param el
 */
export declare function resolveDefaults(event: Event, opts: Options | [[string, any]], el?: Element | string): any;
