/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.netflix.hystrix.contrib.javanica.annotation.DefaultProperties;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.exception.FallbackDefinitionException;
import com.netflix.hystrix.contrib.javanica.utils.FallbackMethod;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public final class MethodProvider {
    private static final MethodProvider INSTANCE = new MethodProvider();
    private static final FallbackMethodFinder FALLBACK_METHOD_FINDER = new SpecificFallback(new DefaultCallback());
    private Map<Method, Method> cache = new ConcurrentHashMap<Method, Method>();

    private MethodProvider() {
    }

    public static MethodProvider getInstance() {
        return INSTANCE;
    }

    public FallbackMethod getFallbackMethod(Class<?> type, Method commandMethod) {
        return this.getFallbackMethod(type, commandMethod, false);
    }

    public FallbackMethod getFallbackMethod(Class<?> enclosingType, Method commandMethod, boolean extended) {
        if (commandMethod.isAnnotationPresent(HystrixCommand.class)) {
            return FALLBACK_METHOD_FINDER.find(enclosingType, commandMethod, extended);
        }
        return FallbackMethod.ABSENT;
    }

    private void getDefaultFallback() {
    }

    private String getClassLevelFallback(Class<?> enclosingClass) {
        if (enclosingClass.isAnnotationPresent(DefaultProperties.class)) {
            return enclosingClass.getAnnotation(DefaultProperties.class).defaultFallback();
        }
        return "";
    }

    public static Optional<Method> getMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        Method[] methods;
        for (Method method : methods = type.getDeclaredMethods()) {
            if (!method.getName().equals(name) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
            return Optional.of((Object)method);
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            return MethodProvider.getMethod(superClass, name, parameterTypes);
        }
        return Optional.absent();
    }

    public Method unbride(final Method bridgeMethod, Class<?> aClass) throws IOException, NoSuchMethodException, ClassNotFoundException {
        if (bridgeMethod.isBridge() && bridgeMethod.isSynthetic()) {
            if (this.cache.containsKey(bridgeMethod)) {
                return this.cache.get(bridgeMethod);
            }
            ClassReader classReader = new ClassReader(aClass.getName());
            final MethodSignature methodSignature = new MethodSignature();
            classReader.accept(new ClassVisitor(327680){

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    boolean bridge;
                    boolean bl = bridge = (access & 0x40) != 0 && (access & 0x1000) != 0;
                    if (bridge && bridgeMethod.getName().equals(name) && MethodProvider.getParameterCount(desc) == bridgeMethod.getParameterTypes().length) {
                        return new MethodFinder(methodSignature);
                    }
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
            }, 0);
            Method method = aClass.getDeclaredMethod(methodSignature.name, methodSignature.getParameterTypes());
            this.cache.put(bridgeMethod, method);
            return method;
        }
        return bridgeMethod;
    }

    private static int getParameterCount(String desc) {
        return MethodProvider.parseParams(desc).length;
    }

    private static String[] parseParams(String desc) {
        String params = desc.split("\\)")[0].replace("(", "");
        if (params.length() == 0) {
            return new String[0];
        }
        return params.split(";");
    }

    private static class MethodFinder
    extends MethodVisitor {
        private MethodSignature methodSignature;

        public MethodFinder(MethodSignature methodSignature) {
            super(327680);
            this.methodSignature = methodSignature;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.methodSignature.name = name;
            this.methodSignature.desc = desc;
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private static class MethodSignature {
        String name;
        String desc;

        private MethodSignature() {
        }

        public Class<?>[] getParameterTypes() throws ClassNotFoundException {
            if (this.desc == null) {
                return new Class[0];
            }
            String[] params = MethodProvider.parseParams(this.desc);
            Class[] parameterTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                String arg = params[i].substring(1).replace("/", ".");
                parameterTypes[i] = Class.forName(arg);
            }
            return parameterTypes;
        }
    }

    private static abstract class FallbackMethodFinder {
        FallbackMethodFinder next;

        public FallbackMethodFinder() {
        }

        public FallbackMethodFinder(FallbackMethodFinder next) {
            this.next = next;
        }

        boolean isDefault() {
            return false;
        }

        boolean isSpecific() {
            return false;
        }

        public abstract String getFallbackName(Class<?> var1, Method var2);

        public FallbackMethod find(Class<?> enclosingType, Method commandMethod, boolean extended) {
            if (this.canHandle(enclosingType, commandMethod)) {
                return this.doFind(enclosingType, commandMethod, extended);
            }
            if (this.next != null) {
                return this.next.find(enclosingType, commandMethod, extended);
            }
            return FallbackMethod.ABSENT;
        }

        abstract boolean canHandle(Class<?> var1, Method var2);

        private FallbackMethod doFind(Class<?> enclosingType, Method commandMethod, boolean extended) {
            Optional<Method> fMethod;
            String name = this.getFallbackName(enclosingType, commandMethod);
            Object[] fallbackParameterTypes = null;
            fallbackParameterTypes = this.isDefault() ? new Class[]{} : commandMethod.getParameterTypes();
            if (extended && fallbackParameterTypes[fallbackParameterTypes.length - 1] == Throwable.class) {
                fallbackParameterTypes = (Class[])ArrayUtils.remove((Object[])fallbackParameterTypes, (int)(fallbackParameterTypes.length - 1));
            }
            Class[] extendedFallbackParameterTypes = Arrays.copyOf(fallbackParameterTypes, fallbackParameterTypes.length + 1);
            extendedFallbackParameterTypes[fallbackParameterTypes.length] = Throwable.class;
            Optional<Method> exFallbackMethod = MethodProvider.getMethod(enclosingType, name, extendedFallbackParameterTypes);
            Method method = (Method)exFallbackMethod.or(fMethod = MethodProvider.getMethod(enclosingType, name, fallbackParameterTypes)).orNull();
            if (method == null) {
                throw new FallbackDefinitionException("fallback method wasn't found: " + name + "(" + Arrays.toString(fallbackParameterTypes) + ")");
            }
            return new FallbackMethod(method, exFallbackMethod.isPresent(), this.isDefault());
        }
    }

    private static class DefaultCallback
    extends FallbackMethodFinder {
        private DefaultCallback() {
        }

        @Override
        boolean isDefault() {
            return true;
        }

        @Override
        public String getFallbackName(Class<?> enclosingType, Method commandMethod) {
            String commandDefaultFallback = commandMethod.getAnnotation(HystrixCommand.class).defaultFallback();
            String classDefaultFallback = (String)Optional.fromNullable((Object)enclosingType.getAnnotation(DefaultProperties.class)).transform((Function)new Function<DefaultProperties, String>(){

                public String apply(DefaultProperties input) {
                    return input.defaultFallback();
                }
            }).or((Object)"");
            return (String)StringUtils.defaultIfEmpty((CharSequence)commandDefaultFallback, (CharSequence)classDefaultFallback);
        }

        @Override
        boolean canHandle(Class<?> enclosingType, Method commandMethod) {
            return StringUtils.isNotBlank((CharSequence)this.getFallbackName(enclosingType, commandMethod));
        }
    }

    private static class SpecificFallback
    extends FallbackMethodFinder {
        public SpecificFallback(FallbackMethodFinder next) {
            super(next);
        }

        @Override
        boolean isSpecific() {
            return true;
        }

        @Override
        public String getFallbackName(Class<?> enclosingType, Method commandMethod) {
            return commandMethod.getAnnotation(HystrixCommand.class).fallbackMethod();
        }

        @Override
        boolean canHandle(Class<?> enclosingType, Method commandMethod) {
            return StringUtils.isNotBlank((CharSequence)this.getFallbackName(enclosingType, commandMethod));
        }
    }
}

