/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.ribbon;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RetryContext;

public class FeignRetryPolicy
extends InterceptorRetryPolicy {
    private HttpRequest request;
    private String serviceId;

    public FeignRetryPolicy(HttpRequest request, LoadBalancedRetryPolicy policy, ServiceInstanceChooser serviceInstanceChooser, String serviceName) {
        super(request, policy, serviceInstanceChooser, serviceName);
        this.request = request;
        this.serviceId = serviceName;
    }

    public boolean canRetry(RetryContext context) {
        if (context.getRetryCount() == 0) {
            return true;
        }
        return super.canRetry(context);
    }

    public RetryContext open(RetryContext parent) {
        LoadBalancedRetryContext context = new LoadBalancedRetryContext(parent, this.request);
        context.setServiceInstance((ServiceInstance)new FeignRetryPolicyServiceInstance(this.serviceId, this.request));
        return context;
    }

    class FeignRetryPolicyServiceInstance
    implements ServiceInstance {
        private String serviceId;
        private HttpRequest request;
        private Map<String, String> metadata;

        FeignRetryPolicyServiceInstance(String serviceId, HttpRequest request) {
            this.serviceId = serviceId;
            this.request = request;
            this.metadata = new HashMap<String, String>();
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public String getHost() {
            return this.request.getURI().getHost();
        }

        public int getPort() {
            return this.request.getURI().getPort();
        }

        public boolean isSecure() {
            return "https".equals(this.request.getURI().getScheme());
        }

        public URI getUri() {
            return this.request.getURI();
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

