/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.inspector.internal;

import javax.inject.Inject;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.definition.schema.ProducerSchemaFactory;
import org.apache.servicecomb.inspector.internal.InspectorConfig;
import org.apache.servicecomb.inspector.internal.InspectorImpl;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InspectorBootListener
implements BootListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectorBootListener.class);
    @Inject
    private ProducerSchemaFactory producerSchemaFactory;
    private InspectorConfig inspectorConfig;

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    public void onBootEvent(BootListener.BootEvent event) {
        if (event.getEventType() != BootListener.EventType.AFTER_TRANSPORT) {
            return;
        }
        this.inspectorConfig = (InspectorConfig)event.getScbEngine().getPriorityPropertyManager().createConfigObject(InspectorConfig.class, new Object[0]);
        if (!this.inspectorConfig.isEnabled()) {
            LOGGER.info("inspector is not enabled.");
            return;
        }
        LOGGER.info("inspector is enabled.");
        InspectorImpl inspector = new InspectorImpl(event.getScbEngine(), this.inspectorConfig, RegistryUtils.getServiceRegistry().getMicroservice().getSchemaMap());
        inspector.setPriorityPropertyManager(event.getScbEngine().getPriorityPropertyManager());
        this.producerSchemaFactory.getOrCreateProducerSchema("inspector", InspectorImpl.class, (Object)inspector);
    }
}

