/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.serviceregistry.task.AbstractRegisterTask;
import org.apache.servicecomb.serviceregistry.task.HeartbeatResult;
import org.apache.servicecomb.serviceregistry.task.MicroserviceInstanceHeartbeatTask;
import org.apache.servicecomb.serviceregistry.task.MicroserviceServiceCenterTask;
import org.apache.servicecomb.serviceregistry.task.ServiceCenterTaskMonitor;
import org.apache.servicecomb.serviceregistry.task.TaskStatus;
import org.apache.servicecomb.serviceregistry.task.event.ExceptionEvent;
import org.apache.servicecomb.serviceregistry.task.event.SafeModeChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterTask.class);
    private EventBus eventBus;
    private int interval;
    private int checkTimes;
    private AtomicLong consecutiveFailedTimes = new AtomicLong();
    private AtomicLong consecutiveSucceededTimes = new AtomicLong();
    private boolean safeMode = false;
    private MicroserviceServiceCenterTask microserviceServiceCenterTask;
    private boolean registerInstanceSuccess = false;
    private ServiceCenterTaskMonitor serviceCenterTaskMonitor = new ServiceCenterTaskMonitor();

    public ServiceCenterTask(EventBus eventBus, int interval, int checkTimes, MicroserviceServiceCenterTask microserviceServiceCenterTask) {
        this.eventBus = eventBus;
        this.interval = interval;
        this.checkTimes = checkTimes;
        this.microserviceServiceCenterTask = microserviceServiceCenterTask;
        this.eventBus.register((Object)this);
    }

    @Subscribe
    public void onRegisterTask(AbstractRegisterTask task) {
        LOGGER.info("read {} status is {}", (Object)task.getClass().getSimpleName(), (Object)task.taskStatus);
        if (task.getTaskStatus() == TaskStatus.FINISHED) {
            this.registerInstanceSuccess = true;
        } else {
            this.onException();
        }
    }

    @Subscribe
    public void onMicroserviceInstanceHeartbeatTask(MicroserviceInstanceHeartbeatTask task) {
        if (task.getHeartbeatResult() != HeartbeatResult.SUCCESS) {
            LOGGER.info("read MicroserviceInstanceHeartbeatTask status is {}", (Object)task.taskStatus);
            this.onException();
            if (!this.safeMode && this.consecutiveFailedTimes.incrementAndGet() > (long)this.checkTimes) {
                LOGGER.warn("service center is unavailable, enter safe mode");
                this.eventBus.post((Object)new SafeModeChangeEvent(true));
                this.safeMode = true;
            }
            this.consecutiveSucceededTimes.set(0L);
            return;
        }
        if (this.safeMode && this.consecutiveSucceededTimes.incrementAndGet() > (long)this.checkTimes) {
            LOGGER.warn("service center is recovery, exit safe mode");
            this.eventBus.post((Object)new SafeModeChangeEvent(false));
            this.safeMode = false;
        }
        this.consecutiveFailedTimes.set(0L);
    }

    @Subscribe
    public void onExceptionEvent(ExceptionEvent event) {
        LOGGER.info("read exception event, message is :{}", (Object)event.getThrowable().getMessage());
        this.onException();
    }

    private void onException() {
        if (this.registerInstanceSuccess) {
            this.registerInstanceSuccess = false;
        }
    }

    public void init() {
        this.microserviceServiceCenterTask.run();
    }

    @Override
    public void run() {
        try {
            this.serviceCenterTaskMonitor.beginCycle(this.interval);
            this.microserviceServiceCenterTask.run();
            this.serviceCenterTaskMonitor.endCycle();
        }
        catch (Throwable e) {
            LOGGER.error("unexpected exception caught from service center task. ", e);
        }
    }

    @VisibleForTesting
    public boolean getSafeMode() {
        return this.safeMode;
    }
}

