/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import org.springframework.beans.NotWritablePropertyException;
import org.springframework.boot.bind.PropertyOrigin;

public class RelaxedBindingNotWritablePropertyException
extends NotWritablePropertyException {
    private final String message;
    private final PropertyOrigin propertyOrigin;

    RelaxedBindingNotWritablePropertyException(NotWritablePropertyException ex, PropertyOrigin propertyOrigin) {
        super(ex.getBeanClass(), ex.getPropertyName());
        this.propertyOrigin = propertyOrigin;
        this.message = "Failed to bind '" + propertyOrigin.getName() + "' from '" + propertyOrigin.getSource().getName() + "' to '" + ex.getPropertyName() + "' property on '" + ex.getBeanClass().getName() + "'";
    }

    public String getMessage() {
        return this.message;
    }

    public PropertyOrigin getPropertyOrigin() {
        return this.propertyOrigin;
    }
}

