/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.io.Serializable;
import rx.Notification;
import rx.Observer;

public final class NotificationLite<T> {
    private static final NotificationLite INSTANCE = new NotificationLite();
    private static final Object ON_COMPLETED_SENTINEL = new Serializable(){
        private static final long serialVersionUID = 1L;

        public String toString() {
            return "Notification=>Completed";
        }
    };
    private static final Object ON_NEXT_NULL_SENTINEL = new Serializable(){
        private static final long serialVersionUID = 2L;

        public String toString() {
            return "Notification=>NULL";
        }
    };

    private NotificationLite() {
    }

    public static <T> NotificationLite<T> instance() {
        return INSTANCE;
    }

    public Object next(T t) {
        if (t == null) {
            return ON_NEXT_NULL_SENTINEL;
        }
        return t;
    }

    public Object completed() {
        return ON_COMPLETED_SENTINEL;
    }

    public Object error(Throwable e) {
        return new OnErrorSentinel(e);
    }

    public boolean accept(Observer<? super T> o, Object n) {
        if (n == ON_COMPLETED_SENTINEL) {
            o.onCompleted();
            return true;
        }
        if (n == ON_NEXT_NULL_SENTINEL) {
            o.onNext(null);
            return false;
        }
        if (n != null) {
            if (n.getClass() == OnErrorSentinel.class) {
                o.onError(((OnErrorSentinel)n).e);
                return true;
            }
            o.onNext(n);
            return false;
        }
        throw new IllegalArgumentException("The lite notification can not be null");
    }

    public boolean isCompleted(Object n) {
        return n == ON_COMPLETED_SENTINEL;
    }

    public boolean isError(Object n) {
        return n instanceof OnErrorSentinel;
    }

    public boolean isNull(Object n) {
        return n == ON_NEXT_NULL_SENTINEL;
    }

    public boolean isNext(Object n) {
        return n != null && !this.isError(n) && !this.isCompleted(n);
    }

    public Notification.Kind kind(Object n) {
        if (n == null) {
            throw new IllegalArgumentException("The lite notification can not be null");
        }
        if (n == ON_COMPLETED_SENTINEL) {
            return Notification.Kind.OnCompleted;
        }
        if (n instanceof OnErrorSentinel) {
            return Notification.Kind.OnError;
        }
        return Notification.Kind.OnNext;
    }

    public T getValue(Object n) {
        return (T)(n == ON_NEXT_NULL_SENTINEL ? null : n);
    }

    public Throwable getError(Object n) {
        return ((OnErrorSentinel)n).e;
    }

    private static class OnErrorSentinel
    implements Serializable {
        private static final long serialVersionUID = 3L;
        final Throwable e;

        public OnErrorSentinel(Throwable e) {
            this.e = e;
        }

        public String toString() {
            return "Notification=>Error:" + this.e;
        }
    }
}

