/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch;

import java.util.concurrent.TimeUnit;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.fn.Consumer;

public final class SynchronousDispatcher
implements Dispatcher {
    public static final SynchronousDispatcher INSTANCE = new SynchronousDispatcher();

    @Override
    public boolean alive() {
        return true;
    }

    @Override
    public boolean awaitAndShutdown() {
        return true;
    }

    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        return true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void forceShutdown() {
    }

    @Override
    public <E> void tryDispatch(E event, Consumer<E> consumer, Consumer<Throwable> errorConsumer) {
        this.dispatch(event, consumer, errorConsumer);
    }

    @Override
    public <E> void dispatch(E event, Consumer<E> eventConsumer, Consumer<Throwable> errorConsumer) {
        block3: {
            try {
                eventConsumer.accept(event);
            }
            catch (Exception e) {
                if (errorConsumer != null) {
                    errorConsumer.accept(e);
                }
                if (!Environment.alive()) break block3;
                Environment.get().routeError(e);
            }
        }
    }

    public String toString() {
        return "immediate";
    }

    @Override
    public void execute(Runnable command) {
        command.run();
    }

    @Override
    public long remainingSlots() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean supportsOrdering() {
        return true;
    }

    @Override
    public long backlogSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean inContext() {
        return true;
    }
}

